/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.bandana.persistence.dao.hibernate;

import com.atlassian.confluence.setup.bandana.ConfluenceBandanaRecord;
import com.atlassian.confluence.setup.bandana.persistence.dao.ConfluenceBandanaRecordDao;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.StringType;
import net.sf.hibernate.type.Type;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class HibernateConfluenceBandanaRecordDao
extends HibernateDaoSupport
implements ConfluenceBandanaRecordDao {
    private static final Logger log = Logger.getLogger(HibernateConfluenceBandanaRecordDao.class);

    public synchronized void saveOrUpdate(ConfluenceBandanaRecord record) {
        ConfluenceBandanaRecord persistent = this.getPersistent(record);
        if (persistent == null) {
            if (record.getId() != 0L) {
                log.error((Object)"Attempted to save bandana record with ID already set. CONF-8785!");
                throw new IllegalStateException("Attempted to save a Bandana record that already has an ID. CONF-8785");
            }
            this.getHibernateTemplate().save((Object)record);
        } else {
            BeanUtils.copyProperties((Object)record, (Object)persistent, (String[])new String[]{"id"});
        }
    }

    public ConfluenceBandanaRecord getRecord(final String context, final String key) {
        return (ConfluenceBandanaRecord)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("confluence.bandanarecord_findByContextAndKey");
                query.setString("context", context);
                query.setString("key", key);
                List results = query.list();
                if (results != null && results.size() > 0) {
                    return results.get(0);
                }
                return null;
            }
        });
    }

    public void remove(ConfluenceBandanaRecord record) {
        ConfluenceBandanaRecord persistent = this.getPersistent(record);
        if (persistent != null) {
            this.getHibernateTemplate().delete((Object)persistent);
        }
    }

    private ConfluenceBandanaRecord getPersistent(ConfluenceBandanaRecord record) {
        return this.getRecord(record.getContext(), record.getKey());
    }

    public void removeAllInContext(String context) {
        this.getHibernateTemplate().delete("from ConfluenceBandanaRecord cbr where cbr.context = :context", (Object)context, (Type)new StringType());
    }

    public Collection findForContext(final String context) {
        return (Collection)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("confluence.bandanarecord_findByContext");
                query.setString("context", context);
                List results = query.list();
                if (results == null) {
                    return Collections.EMPTY_LIST;
                }
                return results;
            }
        });
    }
}

