/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.quartz;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.concurrent.Lock;
import com.atlassian.confluence.setup.quartz.ConfluenceQuartzUtil;
import com.atlassian.quartz.QuartzUtil;
import org.apache.log4j.Category;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public abstract class AbstractClusterAwareQuartzJobBean
extends QuartzJobBean {
    private static Category log = Category.getInstance(AbstractClusterAwareQuartzJobBean.class);
    private ClusterManager clusterManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeInternal(JobExecutionContext jobExecutionContext) {
        boolean runOncePerCluster = ConfluenceQuartzUtil.isRunOncePerCluster(jobExecutionContext);
        Lock lock = null;
        boolean gotLock = false;
        try {
            if (runOncePerCluster) {
                lock = this.clusterManager.getClusteredLock(jobExecutionContext.getJobDetail().getName() + ".executionlock");
                gotLock = lock.tryLock();
                if (!gotLock) {
                    log.info((Object)("Skipping execution of " + jobExecutionContext.getJobDetail().getName() + ". It is already running on a node in this cluster."));
                    return;
                }
            } else if (QuartzUtil.isJobExecuting((JobExecutionContext)jobExecutionContext)) {
                log.info((Object)("Skipping execution of " + jobExecutionContext.getJobDetail().getName() + ". It is already running."));
                return;
            }
            this.surroundJobExecutionWithLogging(jobExecutionContext);
        }
        finally {
            if (runOncePerCluster && gotLock) {
                lock.unlock();
            }
        }
    }

    private void surroundJobExecutionWithLogging(JobExecutionContext jobExecutionContext) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Scheduled job : " + jobExecutionContext.getJobDetail().getName() + " is starting"));
        }
        try {
            this.executeJob(jobExecutionContext);
            if (log.isInfoEnabled()) {
                log.info((Object)("Scheduled job : " + jobExecutionContext.getJobDetail().getName() + " completed"));
            }
        }
        catch (JobExecutionException e) {
            log.error((Object)("Scheduled job : " + jobExecutionContext.getJobDetail().getName() + " failed to complete"), (Throwable)e);
        }
    }

    protected abstract void executeJob(JobExecutionContext var1) throws JobExecutionException;

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }
}

