/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.settings;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaKeys;
import com.atlassian.confluence.setup.settings.GlobalDescription;
import com.atlassian.confluence.setup.settings.GlobalDescriptionDao;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.setup.settings.SpaceSettings;
import com.atlassian.upgrade.UpgradeManager;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class DefaultSettingsManager
implements SettingsManager,
ConfluenceBandanaKeys {
    BandanaManager bandanaManager;
    private UpgradeManager upgradeManager;
    private GlobalDescriptionDao globalDescriptionDao;
    private static final Logger log = Logger.getLogger(DefaultSettingsManager.class);

    public Settings getGlobalSettings() {
        Settings settings = null;
        if (this.upgradeManager.isUpgraded()) {
            settings = (Settings)this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "atlassian.confluence.settings");
        }
        if (settings == null) {
            settings = new Settings();
        }
        return settings;
    }

    public void updateGlobalSettings(Settings settings) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.settings", (Object)settings);
    }

    public SpaceSettings getSpaceSettings(String spaceKey) {
        SpaceSettings spaceSettings = null;
        if (this.upgradeManager.isUpgraded()) {
            spaceSettings = (SpaceSettings)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), "atlassian.confluence.space.settings");
        }
        if (spaceSettings == null) {
            spaceSettings = new SpaceSettings(spaceKey);
        }
        return spaceSettings;
    }

    public void updateSpaceSettings(SpaceSettings spaceSettings) {
        if (!TextUtils.stringSet((String)spaceSettings.getSpaceKey())) {
            throw new IllegalArgumentException("SpaceSettings object cannot be saved. It does not have a space key set on it.");
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceSettings.getSpaceKey()), "atlassian.confluence.space.settings", (Object)spaceSettings);
    }

    public Serializable getPluginSettings(String pluginKey) {
        return (Serializable)this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "plugin.settings." + pluginKey);
    }

    public void updatePluginSettings(String pluginKey, Serializable pluginSettings) {
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "plugin.settings." + pluginKey, (Object)pluginSettings);
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public boolean isNofollowExternalLinks() {
        return this.getGlobalSettings().isNofollowExternalLinks();
    }

    public void setUpgradeManager(UpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }

    public GlobalDescription getGlobalDescription() {
        return this.globalDescriptionDao.getGlobalDescription();
    }

    public void updateGlobalDescription(GlobalDescription globalDescription) {
        if (this.getGlobalDescription() != null && this.getGlobalDescription() != globalDescription && globalDescription.getId() != this.getGlobalDescription().getId()) {
            log.error((Object)"One GlobalDescription object already exists. The new one will not be saved.");
            log.debug((Object)"Attempt to create the second GlobalDescription object: ", new Throwable());
            return;
        }
        this.globalDescriptionDao.save(globalDescription);
    }

    public void setGlobalDescriptionDao(GlobalDescriptionDao globalDescriptionDao) {
        this.globalDescriptionDao = globalDescriptionDao;
    }
}

