/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.settings;

import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.setup.settings.CustomHtmlSettings;
import com.atlassian.confluence.setup.settings.beans.CaptchaSettings;
import com.atlassian.confluence.setup.settings.beans.ColourSchemesSettings;
import com.atlassian.confluence.setup.settings.beans.ReferrerSettings;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.io.Serializable;

public class Settings
implements Serializable {
    boolean allowCamelCase = false;
    boolean allowTrackbacks = false;
    boolean allowThreadedComments = true;
    boolean viewSpaceGoesToSpaceSummary = false;
    boolean externalUserManagement = false;
    boolean denyPublicSignup = false;
    boolean emailAdminMessageOff = false;
    boolean almostSupportPeriodEndMessageOff = false;
    boolean supportPeriodEndMessageOff = false;
    boolean baseUrlAdminMessageOff = false;
    boolean allowRemoteApi = true;
    boolean allowRemoteApiAnonymous = false;
    private boolean antiXssMode = false;
    boolean gzippingResponse = false;
    boolean disableLogo = false;
    boolean sharedMode = false;
    ReferrerSettings referrerSettings;
    CaptchaSettings captchaSettings = new CaptchaSettings();
    CustomHtmlSettings customHtmlSettings = new CustomHtmlSettings();
    ColourSchemesSettings colourSchemesSettings = new ColourSchemesSettings("custom");
    private long attachmentMaxSize = 0xA00000L;
    private int draftSaveInterval = 30000;
    private int maxAttachmentsInUI = 5;
    private String siteHomePage;
    private String siteTitle = "Confluence";
    private String siteWelcomeMessage;
    private String emailAddressVisibility = "email.address.public";
    private String defaultEncoding = "UTF-8";
    private int maxThumbHeight = 200;
    private int maxThumbWidth = 200;
    private boolean backupAttachmentsDaily = true;
    private boolean nofollowExternalLinks = true;
    private String indexingLanguage = "english";
    private String globalDefaultLocale = "en_GB";
    private String dailyBackupFilePrefix = "daily-backup-";
    private String dailyBackupDateFormatPattern = "yyyy_MM_dd";
    private String supportRequestEmail = "confluence-autosupportrequests@atlassian.com";
    private boolean enableWysiwyg = true;
    private boolean useWysiwygByDefault = true;
    private int numberOfBreadcrumbAncestors = 1;
    private String defaultSpaceHomepageTitle = "Home";
    private String defaultSpaceHomepageContent = "This is the home page for the {0} space.";
    private String defaultPersonalSpaceHomepageContent = "This is the home page for the {0} space.";
    private String baseUrl;
    private String attachmentDataStore = "file.system.based.attachments.storage";
    private String webdavServerUrl;
    private String webdavUsername;
    private String webdavPassword;
    private boolean displayLinkIcons = false;
    public static final String DEFAULT_DEFAULT_ENCODING = "UTF-8";
    public static final String EMAIL_ADDRESS_PUBLIC = "email.address.public";
    public static final String EMAIL_ADDRESS_MASKED = "email.address.masked";
    public static final String EMAIL_ADDRESS_PRIVATE = "email.address.private";
    public static final String DAILY_BACKUP_DIRECTORY = "backups";
    public static final String ENGLISH = "english";
    public static final String GERMAN = "german";
    public static final String RUSSIAN = "russian";
    public static final String CJK = "CJK";
    public static final String CUSTOM_JAPANESE = "CJK";
    public static final String CHINESE = "chinese";
    public static final String FRENCH = "french";
    public static final String GREEK = "greek";
    public static final String BRAZILIAN = "brazilian";
    public static final String CZECH = "czech";
    public static final String LOCALE_ENGLISH = "en_GB";
    public static final String LOCALE_GERMAN = "de_DE";
    public static final String LOCALE_RUSSIAN = "ru_RU";
    public static final String LOCALE_JAPANESE = "ja_JP";
    private ConfluenceHttpParameters confluenceHttpParameters = new ConfluenceHttpParameters();

    public Settings() {
    }

    public Settings(Settings settings) {
        this.allowCamelCase = settings.allowCamelCase;
        this.allowTrackbacks = settings.allowTrackbacks;
        this.allowThreadedComments = settings.allowThreadedComments;
        this.viewSpaceGoesToSpaceSummary = settings.viewSpaceGoesToSpaceSummary;
        this.externalUserManagement = settings.externalUserManagement;
        this.denyPublicSignup = settings.denyPublicSignup;
        this.emailAdminMessageOff = settings.emailAdminMessageOff;
        this.almostSupportPeriodEndMessageOff = settings.almostSupportPeriodEndMessageOff;
        this.supportPeriodEndMessageOff = settings.supportPeriodEndMessageOff;
        this.baseUrlAdminMessageOff = settings.baseUrlAdminMessageOff;
        this.allowRemoteApi = settings.allowRemoteApi;
        this.allowRemoteApiAnonymous = settings.allowRemoteApiAnonymous;
        this.antiXssMode = settings.antiXssMode;
        this.gzippingResponse = settings.gzippingResponse;
        this.disableLogo = settings.disableLogo;
        this.customHtmlSettings = new CustomHtmlSettings(settings.getCustomHtmlSettings());
        this.referrerSettings = settings.getReferrerSettings();
        this.attachmentMaxSize = settings.attachmentMaxSize;
        this.siteHomePage = settings.siteHomePage;
        this.siteTitle = settings.siteTitle;
        this.siteWelcomeMessage = settings.siteWelcomeMessage;
        this.emailAddressVisibility = settings.emailAddressVisibility;
        this.defaultEncoding = settings.defaultEncoding;
        this.maxThumbHeight = settings.maxThumbHeight;
        this.maxThumbWidth = settings.maxThumbWidth;
        this.backupAttachmentsDaily = settings.backupAttachmentsDaily;
        this.nofollowExternalLinks = settings.nofollowExternalLinks;
        this.indexingLanguage = settings.indexingLanguage;
        this.dailyBackupFilePrefix = settings.dailyBackupFilePrefix;
        this.dailyBackupDateFormatPattern = settings.dailyBackupDateFormatPattern;
        this.enableWysiwyg = settings.enableWysiwyg;
        this.useWysiwygByDefault = settings.useWysiwygByDefault;
        this.numberOfBreadcrumbAncestors = settings.numberOfBreadcrumbAncestors;
        this.defaultSpaceHomepageTitle = settings.defaultSpaceHomepageTitle;
        this.defaultSpaceHomepageContent = settings.defaultSpaceHomepageContent;
        this.defaultPersonalSpaceHomepageContent = settings.defaultPersonalSpaceHomepageContent;
        this.captchaSettings = new CaptchaSettings(settings.captchaSettings);
        this.colourSchemesSettings = new ColourSchemesSettings(settings.colourSchemesSettings);
        this.baseUrl = settings.getBaseUrl();
        this.attachmentDataStore = settings.getAttachmentDataStore();
        this.webdavServerUrl = settings.getWebdavServerUrl();
        this.webdavUsername = settings.getWebdavUsername();
        this.webdavPassword = settings.getWebdavPassword();
        this.globalDefaultLocale = settings.getGlobalDefaultLocale();
        this.sharedMode = settings.sharedMode;
        this.displayLinkIcons = settings.displayLinkIcons;
        this.confluenceHttpParameters = settings.confluenceHttpParameters;
    }

    public ConfluenceHttpParameters getConfluenceHttpParameters() {
        return this.confluenceHttpParameters;
    }

    public void setConfluenceHttpParameters(ConfluenceHttpParameters confluenceHttpParameters) {
        this.confluenceHttpParameters = confluenceHttpParameters;
    }

    public boolean isAllowCamelCase() {
        return this.allowCamelCase;
    }

    public void setAllowCamelCase(boolean allowCamelCase) {
        this.allowCamelCase = allowCamelCase;
    }

    public boolean isAllowTrackbacks() {
        return this.allowTrackbacks;
    }

    public void setAllowTrackbacks(boolean allowTrackbacks) {
        this.allowTrackbacks = allowTrackbacks;
    }

    public boolean isAllowThreadedComments() {
        return this.allowThreadedComments;
    }

    public void setAllowThreadedComments(boolean allowThreadedComments) {
        this.allowThreadedComments = allowThreadedComments;
    }

    public boolean isViewSpaceGoesToSpaceSummary() {
        return this.viewSpaceGoesToSpaceSummary;
    }

    public void setViewSpaceGoesToSpaceSummary(boolean viewSpaceGoesToSpaceSummary) {
        this.viewSpaceGoesToSpaceSummary = viewSpaceGoesToSpaceSummary;
    }

    public boolean isExternalUserManagement() {
        return this.externalUserManagement;
    }

    public void setExternalUserManagement(boolean externalUserManagement) {
        this.externalUserManagement = externalUserManagement;
    }

    public boolean isDenyPublicSignup() {
        return this.denyPublicSignup;
    }

    public void setDenyPublicSignup(boolean denyPublicSignup) {
        this.denyPublicSignup = denyPublicSignup;
    }

    public ReferrerSettings getReferrerSettings() {
        if (this.referrerSettings == null) {
            this.referrerSettings = new ReferrerSettings();
        }
        return this.referrerSettings;
    }

    public void setReferrerSettings(ReferrerSettings referrerSettings) {
        this.referrerSettings = referrerSettings;
    }

    public CaptchaSettings getCaptchaSettings() {
        if (this.captchaSettings == null) {
            this.captchaSettings = new CaptchaSettings();
        }
        return this.captchaSettings;
    }

    public void setCaptchaSettings(CaptchaSettings captchaSettings) {
        this.captchaSettings = captchaSettings;
    }

    public String getSiteHomePage() {
        return this.siteHomePage;
    }

    public void setSiteHomePage(String siteHomePage) {
        this.siteHomePage = siteHomePage;
    }

    public String getSiteWelcomeMessage() {
        return this.siteWelcomeMessage;
    }

    public void setSiteWelcomeMessage(String siteWelcomeMessage) {
        this.siteWelcomeMessage = siteWelcomeMessage;
    }

    public String getEmailAddressVisibility() {
        return this.emailAddressVisibility;
    }

    public void setEmailAddressVisibility(String emailAddressVisibility) {
        this.emailAddressVisibility = emailAddressVisibility;
    }

    public boolean areEmailAddressesPrivate() {
        return EMAIL_ADDRESS_PRIVATE.equals(this.getEmailAddressVisibility());
    }

    public long getAttachmentMaxSize() {
        return this.attachmentMaxSize;
    }

    public void setAttachmentMaxSize(long attachmentMaxSize) {
        this.attachmentMaxSize = attachmentMaxSize;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public int getMaxThumbHeight() {
        return this.maxThumbHeight;
    }

    public void setMaxThumbHeight(int maxThumbHeight) {
        this.maxThumbHeight = maxThumbHeight;
    }

    public int getMaxThumbWidth() {
        return this.maxThumbWidth;
    }

    public void setMaxThumbWidth(int maxThumbWidth) {
        this.maxThumbWidth = maxThumbWidth;
    }

    public boolean isBackupAttachmentsDaily() {
        return this.backupAttachmentsDaily;
    }

    public void setBackupAttachmentsDaily(boolean backupAttachmentsDaily) {
        this.backupAttachmentsDaily = backupAttachmentsDaily;
    }

    public String getIndexingLanguage() {
        return this.indexingLanguage;
    }

    public void setIndexingLanguage(String indexingLanguage) {
        this.indexingLanguage = indexingLanguage;
    }

    public String getGlobalDefaultLocale() {
        return this.globalDefaultLocale;
    }

    public void setGlobalDefaultLocale(String localeString) {
        this.globalDefaultLocale = localeString;
    }

    public boolean isEmailAdminMessageOff() {
        return this.emailAdminMessageOff;
    }

    public void setEmailAdminMessageOff(boolean emailAdminMessageOff) {
        this.emailAdminMessageOff = emailAdminMessageOff;
    }

    public boolean isBaseUrlAdminMessageOff() {
        return this.baseUrlAdminMessageOff;
    }

    public void setBaseUrlAdminMessageOff(boolean baseUrlAdminMessageOff) {
        this.baseUrlAdminMessageOff = baseUrlAdminMessageOff;
    }

    public boolean isAlmostSupportPeriodEndMessageOff() {
        return this.almostSupportPeriodEndMessageOff;
    }

    public void setAlmostSupportPeriodEndMessageOff(boolean almostSupportPeriodEndMessageOff) {
        this.almostSupportPeriodEndMessageOff = almostSupportPeriodEndMessageOff;
    }

    public boolean isAllowRemoteApi() {
        return this.allowRemoteApi;
    }

    public void setAllowRemoteApi(boolean allowRemoteApi) {
        this.allowRemoteApi = allowRemoteApi;
    }

    public boolean isAllowRemoteApiAnonymous() {
        return this.allowRemoteApiAnonymous;
    }

    public void setAllowRemoteApiAnonymous(boolean allowRemoteApiAnonymous) {
        this.allowRemoteApiAnonymous = allowRemoteApiAnonymous;
    }

    public int getMaxAttachmentsInUI() {
        return this.maxAttachmentsInUI;
    }

    public void setMaxAttachmentsInUI(int maxAttachmentsInUI) {
        this.maxAttachmentsInUI = maxAttachmentsInUI;
    }

    public boolean isGzippingResponse() {
        return this.gzippingResponse;
    }

    public void setGzippingResponse(boolean gzippingResponse) {
        this.gzippingResponse = gzippingResponse;
    }

    public void setNofollowExternalLinks(boolean nofollowExternalLinks) {
        this.nofollowExternalLinks = nofollowExternalLinks;
    }

    public boolean isNofollowExternalLinks() {
        return this.nofollowExternalLinks;
    }

    public String getDailyBackupFilePrefix() {
        return this.dailyBackupFilePrefix;
    }

    public void setDailyBackupFilePrefix(String dailyBackupFilePrefix) {
        this.dailyBackupFilePrefix = dailyBackupFilePrefix;
    }

    public String getDailyBackupDateFormatPattern() {
        return this.dailyBackupDateFormatPattern;
    }

    public void setDailyBackupDateFormatPattern(String dailyBackupDateFormatPattern) {
        this.dailyBackupDateFormatPattern = dailyBackupDateFormatPattern;
    }

    public String getSiteTitle() {
        return this.siteTitle;
    }

    public void setSiteTitle(String siteTitle) {
        this.siteTitle = siteTitle;
    }

    public boolean isEnableWysiwyg() {
        return this.enableWysiwyg;
    }

    public void setEnableWysiwyg(boolean enableWysiwyg) {
        this.enableWysiwyg = enableWysiwyg;
    }

    public boolean isUseWysiwygByDefault() {
        return this.useWysiwygByDefault;
    }

    public void setUseWysiwygByDefault(boolean useWysiwygByDefault) {
        this.useWysiwygByDefault = useWysiwygByDefault;
    }

    public int getNumberOfBreadcrumbAncestors() {
        return this.numberOfBreadcrumbAncestors;
    }

    public void setNumberOfBreadcrumbAncestors(int numberOfBreadcrumbAncestors) {
        this.numberOfBreadcrumbAncestors = numberOfBreadcrumbAncestors;
    }

    public boolean isDisableLogo() {
        return this.disableLogo;
    }

    public void setDisableLogo(boolean disableLogo) {
        this.disableLogo = disableLogo;
    }

    public int getDraftSaveInterval() {
        return this.draftSaveInterval;
    }

    public void setDraftSaveInterval(int draftSaveInterval) {
        this.draftSaveInterval = draftSaveInterval;
    }

    public CustomHtmlSettings getCustomHtmlSettings() {
        return this.customHtmlSettings;
    }

    public void setCustomHtmlSettings(CustomHtmlSettings customHtmlSettings) {
        this.customHtmlSettings = customHtmlSettings;
    }

    public ColourSchemesSettings getColourSchemesSettings() {
        if (this.colourSchemesSettings == null) {
            this.colourSchemesSettings = new ColourSchemesSettings("custom");
        }
        return this.colourSchemesSettings;
    }

    public void setColourSchemesSettings(ColourSchemesSettings colourSchemesSettings) {
        this.colourSchemesSettings = colourSchemesSettings;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public String getDefaultSpaceHomepageTitle() {
        return this.defaultSpaceHomepageTitle;
    }

    public void setDefaultSpaceHomepageTitle(String defaultSpaceHomepageTitle) {
        this.defaultSpaceHomepageTitle = defaultSpaceHomepageTitle;
    }

    public String getDefaultSpaceHomepageContent() {
        return this.defaultSpaceHomepageContent;
    }

    public void setDefaultSpaceHomepageContent(String defaultSpaceHomepageContent) {
        this.defaultSpaceHomepageContent = defaultSpaceHomepageContent;
    }

    public String getBaseUrl() {
        if (this.baseUrl == null) {
            this.baseUrl = GeneralUtil.lookupDomainName(ServletActionContext.getRequest());
        }
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getAttachmentDataStore() {
        return this.attachmentDataStore;
    }

    public void setAttachmentDataStore(String attachmentDataStore) {
        this.attachmentDataStore = attachmentDataStore;
    }

    public String getWebdavServerUrl() {
        return this.webdavServerUrl;
    }

    public void setWebdavServerUrl(String webdavServerUrl) {
        this.webdavServerUrl = webdavServerUrl;
    }

    public String getWebdavUsername() {
        return this.webdavUsername;
    }

    public void setWebdavUsername(String webdavUsername) {
        this.webdavUsername = webdavUsername;
    }

    public String getWebdavPassword() {
        return this.webdavPassword;
    }

    public void setWebdavPassword(String webdavPassword) {
        this.webdavPassword = webdavPassword;
    }

    public boolean isWebdavEnabled() {
        return TextUtils.stringSet((String)this.getWebdavServerUrl());
    }

    public boolean isAntiXssMode() {
        return this.antiXssMode;
    }

    public void setAnitXssMode(boolean anitXssMode) {
        this.antiXssMode = anitXssMode;
    }

    public boolean isSharedMode() {
        if ("true".equals(System.getProperty("confluence.sharedMode"))) {
            return true;
        }
        return this.sharedMode;
    }

    public void setSharedMode(boolean sharedMode) {
        this.sharedMode = sharedMode;
    }

    public boolean isDisplayLinkIcons() {
        return this.displayLinkIcons;
    }

    public void setDisplayLinkIcons(boolean displayLinkIcons) {
        this.displayLinkIcons = displayLinkIcons;
    }

    public String getDefaultPersonalSpaceHomepageContent() {
        return this.defaultPersonalSpaceHomepageContent;
    }

    public void setDefaultPersonalSpaceHomepageContent(String defaultPersonalSpaceHomepageContent) {
        this.defaultPersonalSpaceHomepageContent = defaultPersonalSpaceHomepageContent;
    }

    public String getSupportRequestEmail() {
        return this.supportRequestEmail;
    }

    public void setSupportRequestEmail(String supportRequestEmail) {
        this.supportRequestEmail = supportRequestEmail;
    }
}

