/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.sitemesh;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.setup.velocity.DecoratorName;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.themes.ThemedDecorator;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Category;

public class ConfluenceSpaceDecoratorMapper
extends AbstractDecoratorMapper {
    private static Category log = Category.getInstance(ConfluenceSpaceDecoratorMapper.class);
    private ThemeManager themeManager;

    public Decorator getNamedDecorator(HttpServletRequest request, String decoratorName) {
        Decorator parentDecorator;
        HTMLPage page = (HTMLPage)request.getAttribute("sitemeshPage");
        Decorator decorator = this.getDecorator((Page)page, parentDecorator = super.getNamedDecorator(request, decoratorName), request);
        if (decorator.getName().equals(decoratorName)) {
            return decorator;
        }
        return parentDecorator;
    }

    public Decorator getDecorator(HttpServletRequest httpServletRequest, Page page) {
        Decorator parentDecorator = this.parent.getDecorator(httpServletRequest, page);
        return this.getDecorator(page, parentDecorator, httpServletRequest);
    }

    private Decorator getDecorator(Page page, Decorator parentDecorator, HttpServletRequest request) {
        if (!TextUtils.stringSet((String)parentDecorator.getPage())) {
            return super.getDecorator(request, page);
        }
        Decorator decorator = null;
        String spaceKey = this.lookupSpaceKey(page, request);
        if (page != null && TextUtils.stringSet((String)spaceKey) && this.getThemeManager() != null && (decorator = this.getThemeDecorator(this.getThemeManager().getSpaceTheme(spaceKey), parentDecorator, page)) == null) {
            decorator = this.getSpaceCustomDecorator(parentDecorator, spaceKey);
        }
        if (decorator == null && this.getThemeManager() != null) {
            decorator = this.getThemeDecorator(this.getThemeManager().getGlobalTheme(), parentDecorator, page);
        }
        if (decorator == null) {
            decorator = super.getDecorator(request, page);
        }
        return decorator;
    }

    private String lookupSpaceKey(Page page, HttpServletRequest request) {
        if (page.isPropertySet("page.spacekey")) {
            return page.getProperty("page.spacekey");
        }
        Map params = request.getParameterMap();
        if (params.containsKey("key")) {
            return request.getParameter("key");
        }
        if (params.containsKey("spaceKey")) {
            return request.getParameter("spaceKey");
        }
        if (params.containsKey("pageId")) {
            try {
                long id = Long.parseLong(request.getParameter("pageId"));
                return this.getSpaceManager().getSpaceFromPageId(id);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    private SpaceManager getSpaceManager() {
        return (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
    }

    private Decorator getSpaceCustomDecorator(Decorator parentDecorator, String spaceKey) {
        String decoratorPage = parentDecorator.getPage();
        String spaceDecoratorPage = new DecoratorName(spaceKey, decoratorPage).getSource();
        DefaultDecorator spaceCustomDecorator = null;
        if (!VelocityManager.getInstance().getVelocityEngine().resourceExists(spaceDecoratorPage)) {
            return null;
        }
        try {
            spaceCustomDecorator = new DefaultDecorator(parentDecorator.getName(), spaceDecoratorPage, null);
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving space decorator:" + spaceDecoratorPage), (Throwable)e);
        }
        return spaceCustomDecorator;
    }

    private Decorator getThemeDecorator(Theme theme, Decorator parentDecorator, Page page) {
        if (theme == null) {
            return null;
        }
        ThemedDecorator themedDecorator = theme.getDecorator(parentDecorator.getPage());
        if (themedDecorator == null) {
            return null;
        }
        page.addProperty("theme.resource.path", "/download/resources/" + GeneralUtil.urlEncode(themedDecorator.getResourceKey()) + "/");
        return themedDecorator.getDecorator(parentDecorator);
    }

    private ThemeManager getThemeManager() {
        if (this.themeManager == null && BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            this.themeManager = (ThemeManager)ContainerManager.getComponent((String)"themeManager");
        }
        return this.themeManager;
    }
}

