/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.sitemesh;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.plugin.descriptor.DecoratorModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class PluginDecoratorMapper
extends AbstractDecoratorMapper {
    private PluginAccessor pluginAccessor;

    public Decorator getDecorator(HttpServletRequest httpServletRequest, Page page) {
        if (this.getPluginAccessor() != null) {
            List decoratorModuleDescriptors = this.getPluginAccessor().getEnabledModuleDescriptorsByClass(DecoratorModuleDescriptor.class);
            for (DecoratorModuleDescriptor desc : decoratorModuleDescriptors) {
                Matcher matcher;
                if (desc.getPattern() == null || !(matcher = desc.getPattern().matcher(httpServletRequest.getServletPath())).matches()) continue;
                return this.createDefaultDecorator(desc);
            }
        }
        return super.getDecorator(httpServletRequest, page);
    }

    public Decorator getNamedDecorator(HttpServletRequest httpServletRequest, String name) {
        if (this.getPluginAccessor() != null) {
            List decoratorModuleDescriptors = this.getPluginAccessor().getEnabledModuleDescriptorsByClass(DecoratorModuleDescriptor.class);
            for (DecoratorModuleDescriptor desc : decoratorModuleDescriptors) {
                if (!name.equals(desc.getName())) continue;
                return this.createDefaultDecorator(desc);
            }
        }
        return super.getNamedDecorator(httpServletRequest, name);
    }

    private Decorator createDefaultDecorator(DecoratorModuleDescriptor desc) {
        try {
            VelocityManager.getInstance().getVelocityEngine().getTemplate(desc.getPage());
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't find decorator template " + desc.getPage(), e);
        }
        return new DefaultDecorator(desc.getName(), desc.getPage(), null);
    }

    private PluginAccessor getPluginAccessor() {
        if (this.pluginAccessor == null && BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            this.pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
        }
        return this.pluginAccessor;
    }
}

