/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.velocity;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.webwork.ConfluenceVelocityContext;
import com.atlassian.confluence.util.profiling.ProfilingPageFilter;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.velocity.context.ConfluenceContextUtils;
import com.atlassian.confluence.velocity.htmlsafe.HtmlFragment;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.parser.FastPageParser;
import com.opensymphony.module.sitemesh.util.OutputConverter;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import com.opensymphony.xwork.ActionContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public final class ApplyDecoratorDirective
extends Directive {
    private static final Category log = Category.getInstance(ApplyDecoratorDirective.class);
    public static final String STACK_KEY = DirectiveStack.class.getName();
    private ThreadLocal params = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };

    public String getName() {
        return "applyDecorator";
    }

    public int getType() {
        return 1;
    }

    public void init(RuntimeServices services, InternalContextAdapter adapter, Node node) {
        super.init(services, adapter, node);
        int numArgs = node.jjtGetNumChildren();
        if (numArgs < 2) {
            services.getLog().error((Object)"#applyDecorator error: You need a decorator name in order to use this tag");
        } else if (numArgs > 3) {
            services.getLog().error((Object)"#applyDecorator error: Too many parameters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(InternalContextAdapter adapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        UtilTimerStack.push((String)"ApplyDecoratorDirective.render()");
        DirectiveStack stack = (DirectiveStack)adapter.get(STACK_KEY);
        if (stack == null) {
            stack = new DirectiveStack();
            adapter.put(STACK_KEY, (Object)stack);
        }
        stack.push(this);
        try {
            this.getParams().clear();
            HttpServletRequest request = (HttpServletRequest)adapter.get("req");
            if (request == null) {
                throw new IOException("No request object in context.");
            }
            HttpServletResponse response = (HttpServletResponse)adapter.get("res");
            if (response == null) {
                throw new IOException("No response object in context.");
            }
            String decoratorName = (String)node.jjtGetChild(0).value(adapter);
            StringWriter bodyContent = new StringWriter(1024);
            int bodyNode = 1;
            if (node.jjtGetNumChildren() == 3) {
                bodyNode = 2;
            }
            node.jjtGetChild(bodyNode).render(adapter, (Writer)bodyContent);
            Factory factory = ProfilingPageFilter.getFactory();
            PageParser parser = factory.getPageParser("text/html");
            HTMLPage page = (HTMLPage)((FastPageParser)parser).parse((Reader)new StringReader(bodyContent.toString()));
            request.setAttribute("sitemeshPage", (Object)new ProfilingPageFilter.VelocitySitemeshPage(page));
            Decorator decorator = factory.getDecoratorMapper().getNamedDecorator(request, decoratorName);
            request.removeAttribute("sitemeshPage");
            if (decorator != null) {
                ContainerContext containerContext;
                Context context = VelocityManager.getInstance().createContext(ActionContext.getContext().getValueStack(), request, response);
                ConfluenceVelocityContext cvctx = new ConfluenceVelocityContext();
                for (String key : cvctx.getConfluenceKeys().keySet()) {
                    context.put(key, cvctx.get(key));
                }
                ConfluenceContextUtils.modifyRequestContext(context, request);
                ConfluenceContextUtils.processContextForHtmlRendering(context);
                BootstrapManager setup = (BootstrapManager)BootstrapUtils.getBootstrapManager();
                context.put("setup", (Object)setup);
                if (setup.isSetupComplete() && (containerContext = ContainerManager.getInstance().getContainerContext()) != null) {
                    context.put("renderBean", containerContext.getComponent((Object)"renderBean"));
                }
                context.put("sitemeshPage", (Object)page);
                if (node.jjtGetNumChildren() == 3) {
                    context.put("title", (Object)new HtmlFragment(node.jjtGetChild(1).value(adapter)));
                } else {
                    context.put("title", (Object)new HtmlFragment(page.getTitle()));
                }
                StringWriter buffer = new StringWriter();
                page.writeBody(OutputConverter.getWriter((Writer)buffer));
                context.put("body", (Object)new HtmlFragment(buffer));
                buffer = new StringWriter();
                page.writeHead(OutputConverter.getWriter((Writer)buffer));
                context.put("head", (Object)new HtmlFragment(buffer.toString()));
                context.put("params", (Object)this.getParams());
                try {
                    writer.write(VelocityUtils.getRenderedTemplateWithoutSwallowingErrors(decorator.getPage(), context));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error rendering template for decorator " + decoratorName, e);
                }
            } else {
                throw new IOException("could not find decorator with name: " + decoratorName);
            }
            this.getParams().clear();
            boolean bl = true;
            return bl;
        }
        finally {
            stack.pop();
            UtilTimerStack.pop((String)"ApplyDecoratorDirective.render()");
        }
    }

    public void addParameter(String paramName, Object paramValue) {
        if (paramValue instanceof Map && "params".equals(paramName)) {
            this.getParams().putAll((Map)paramValue);
        } else {
            this.getParams().put(paramName, paramValue);
        }
    }

    private Map getParams() {
        return (Map)this.params.get();
    }

    public class DirectiveStack {
        Stack stack = new Stack();

        public ApplyDecoratorDirective pop() {
            try {
                return (ApplyDecoratorDirective)((Object)this.stack.pop());
            }
            catch (EmptyStackException e) {
                log.info((Object)("Someone's been popping out of order! " + e.getMessage()), (Throwable)e);
                return null;
            }
        }

        public void push(ApplyDecoratorDirective directive) {
            this.stack.push(directive);
        }

        public ApplyDecoratorDirective peek() {
            if (this.stack.size() > 0) {
                return (ApplyDecoratorDirective)((Object)this.stack.peek());
            }
            return null;
        }
    }
}

