/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.webwork;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.plugin.descriptor.VelocityContextItemModuleDescriptor;
import com.atlassian.confluence.security.PermissionHelper;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.confluence.velocity.context.ConfluenceContextUtils;
import com.atlassian.core.util.FileUtils;
import com.atlassian.core.util.WebRequestUtils;
import com.atlassian.license.LicenseManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfluenceVelocityContext
extends VelocityContext {
    private static final Logger log = Logger.getLogger(ConfluenceVelocityContext.class);
    private Map<String, Object> confluenceKeys;
    private boolean containerComponentsAdded = false;
    private static final String GENERAL_UTIL = "generalUtil";
    private static final String TEXT_UTIL = "textUtil";
    private static final String FILE_UTIL = "fileUtil";
    private static final String SERAPH_UTIL = "seraph";
    private static final String WEB_REQ_UTILS = "webReqUtils";
    private static final String LICENSE_MANAGER = "licenseManager";
    private static final String BOOTSTRAP_MANAGER = "bootstrap";
    private static final String CONFLUENCE_SETUP = "setup";
    private static final String PERMISSION_HELPER = "permissionHelper";
    private static final String PERMISSION_CHECK_DISPATCHER = "permissionCheckDispatcher";
    private static final String SETUP_PERSISTER = "setupPersister";
    private static final String SETTINGS_MANAGER = "settingsManager";
    private static final String ATTACHMENT_MANAGER = "attachmentManager";
    private static final String RESOURCE_MANAGER = "resourceManager";
    private static final String USER_ACCESSOR = "userAccessor";
    private static final String RENDER_BEAN = "renderBean";
    private static final String MESSAGE_MANAGER = "messageManager";
    private static final String WEB_RESOURCE_MANAGER = "webResourceManager";
    private static final String WEB_INTERFACE_MANAGER = "webInterfaceManager";
    private static final String STRING_UTILS = "stringUtils";
    private static final String WEB_MENU_MANAGER = "webMenuManager";
    private static final String SPACE_MANAGER = "spaceManager";
    private static final SeraphUtils SERAPH_UTILS_INSTANCE = new SeraphUtils();
    private static final GeneralUtil GENERAL_UTIL_INSTANCE = new GeneralUtil();
    private static final StringUtils STRING_UTILS_INSTANCE = new StringUtils();
    private static final TextUtils TEXT_UTILS_INSTANCE = new TextUtils();

    public ConfluenceVelocityContext() {
        AtlassianBootstrapManager bootstrapManager = BootstrapUtils.getBootstrapManager();
        this.confluenceKeys = new HashMap<String, Object>();
        this.confluenceKeys.put(GENERAL_UTIL, GENERAL_UTIL_INSTANCE);
        this.confluenceKeys.put(STRING_UTILS, STRING_UTILS_INSTANCE);
        this.confluenceKeys.put(TEXT_UTIL, TEXT_UTILS_INSTANCE);
        this.confluenceKeys.put(LICENSE_MANAGER, LicenseManager.getInstance());
        this.confluenceKeys.put(BOOTSTRAP_MANAGER, bootstrapManager);
        this.confluenceKeys.put(CONFLUENCE_SETUP, bootstrapManager);
        this.confluenceKeys.put(SETUP_PERSISTER, bootstrapManager.getSetupPersister());
        this.confluenceKeys.put(FILE_UTIL, new FileUtils());
        this.confluenceKeys.put(WEB_REQ_UTILS, new WebRequestUtils());
        this.confluenceKeys.put(SERAPH_UTIL, SERAPH_UTILS_INSTANCE);
        ConfluenceContextUtils.processContextForHtmlRendering((Context)this);
        this.addSpringComponentsIfSetupComplete();
    }

    public Object internalGet(String key) {
        if (!this.containerComponentsAdded) {
            this.addSpringComponentsIfSetupComplete();
        }
        if (super.internalContainsKey((Object)key)) {
            return super.internalGet(key);
        }
        return this.confluenceKeys.get(key);
    }

    public boolean internalContainsKey(Object key) {
        if (!this.containerComponentsAdded) {
            this.addSpringComponentsIfSetupComplete();
        }
        return super.internalContainsKey(key) || this.confluenceKeys.containsKey(key);
    }

    private void addSpringComponentsIfSetupComplete() {
        if (ContainerManager.isContainerSetup()) {
            this.addContainerComponents();
        }
    }

    private synchronized void addContainerComponents() {
        if (this.containerComponentsAdded) {
            return;
        }
        this.confluenceKeys.put(PERMISSION_HELPER, new PermissionHelper((PermissionManager)ContainerManager.getComponent((String)"permissionManager"), (PersonalInformationManager)ContainerManager.getComponent((String)"personalInformationManager")));
        this.confluenceKeys.put(SETTINGS_MANAGER, ContainerManager.getComponent((String)SETTINGS_MANAGER));
        this.confluenceKeys.put(PERMISSION_CHECK_DISPATCHER, ContainerManager.getComponent((String)PERMISSION_CHECK_DISPATCHER));
        this.confluenceKeys.put(ATTACHMENT_MANAGER, ContainerManager.getComponent((String)ATTACHMENT_MANAGER));
        this.confluenceKeys.put(RESOURCE_MANAGER, ContainerManager.getComponent((String)RESOURCE_MANAGER));
        this.confluenceKeys.put(USER_ACCESSOR, ContainerManager.getComponent((String)USER_ACCESSOR));
        this.confluenceKeys.put(RENDER_BEAN, ContainerManager.getComponent((String)RENDER_BEAN));
        this.confluenceKeys.put(MESSAGE_MANAGER, ContainerManager.getComponent((String)MESSAGE_MANAGER));
        this.confluenceKeys.put(WEB_RESOURCE_MANAGER, ContainerManager.getComponent((String)WEB_RESOURCE_MANAGER));
        this.confluenceKeys.put(WEB_INTERFACE_MANAGER, ContainerManager.getComponent((String)WEB_INTERFACE_MANAGER));
        this.confluenceKeys.put(WEB_MENU_MANAGER, ContainerManager.getComponent((String)WEB_MENU_MANAGER));
        this.confluenceKeys.put(SPACE_MANAGER, ContainerManager.getComponent((String)SPACE_MANAGER));
        PluginAccessor pluginManager = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
        List contextItems = pluginManager.getEnabledModuleDescriptorsByClass(VelocityContextItemModuleDescriptor.class);
        for (VelocityContextItemModuleDescriptor descriptor : contextItems) {
            try {
                this.confluenceKeys.put(descriptor.getContextKey(), descriptor.getModule());
            }
            catch (Throwable t) {
                log.error((Object)("Cannot put '" + descriptor.getContextKey() + "' in Confluence velocity context. Disabling module " + descriptor.getCompleteKey()), t);
                PluginController pluginController = (PluginController)ContainerManager.getComponent((String)"pluginController");
                pluginController.disablePluginModule(descriptor.getCompleteKey());
            }
        }
        this.containerComponentsAdded = true;
    }

    public Map<String, Object> getConfluenceKeys() {
        return this.confluenceKeys;
    }
}

