/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.webwork;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.config.Configuration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ConfluenceWebWorkConfiguration
extends Configuration {
    private Set filePathKeys = new HashSet();

    public ConfluenceWebWorkConfiguration() {
        this.filePathKeys.add("webwork.multipart.saveDir");
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        String setting = null;
        if ("webwork.multipart.maxSize".equals(aName) && ContainerManager.isContainerSetup()) {
            SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
            return String.valueOf(settingsManager.getGlobalSettings().getAttachmentMaxSize());
        }
        if ("webwork.i18n.encoding".equals(aName)) {
            if (!ContainerManager.isContainerSetup()) {
                return "UTF-8";
            }
            SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
            String defaultEncoding = settingsManager.getGlobalSettings().getDefaultEncoding();
            if (TextUtils.stringSet((String)defaultEncoding)) {
                return defaultEncoding;
            }
        }
        if ((setting = this.filePathKeys.contains(aName) ? BootstrapUtils.getBootstrapManager().getFilePathProperty(aName) : BootstrapUtils.getBootstrapManager().getString(aName)) == null) {
            throw new IllegalArgumentException("No such setting:" + aName);
        }
        return setting;
    }

    public boolean isSetImpl(String aName) {
        return BootstrapUtils.getBootstrapManager().getString(aName) != null;
    }

    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot set Confluence Properties through this interface");
    }

    public Iterator listImpl() {
        return BootstrapUtils.getBootstrapManager().getPropertyKeys().iterator();
    }
}

