/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.xstream;

import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.util.ClassLoaderUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;

public class XStreamFactoryBean
implements FactoryBean {
    private XStream xstream;
    private Map aliases;
    private ClassLoader classLoader;

    public XStreamFactoryBean(Map aliases) {
        this(aliases, null);
    }

    public XStreamFactoryBean(Map aliases, ClassLoader classLoader) {
        this.aliases = aliases;
        this.classLoader = classLoader == null ? XStreamFactoryBean.class.getClassLoader() : classLoader;
    }

    public Object getObject() throws Exception {
        if (this.xstream == null) {
            this.xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
            this.xstream.setClassLoader(this.classLoader);
            for (String alias : this.aliases.keySet()) {
                String aliasClassName = (String)this.aliases.get(alias);
                try {
                    Class aliasClass = ClassLoaderUtils.loadClass((String)aliasClassName, XStreamFactoryBean.class);
                    this.xstream.alias(alias, aliasClass);
                }
                catch (ClassNotFoundException e) {
                    throw new InfrastructureException("Error loading XStreamFactoryBean - could not find class : " + aliasClassName + " for alias " + alias, (Throwable)e);
                }
            }
        }
        return this.xstream;
    }

    public Class getObjectType() {
        return XStream.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

