/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceLicenseManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.message.MessageManager;
import com.atlassian.license.License;
import com.atlassian.license.LicenseException;
import com.atlassian.license.LicensePair;
import com.atlassian.license.decoder.LicenseDecoder;
import org.apache.log4j.Category;

public class DefaultSpaceLicenseManager
implements SpaceLicenseManager {
    private static Category log = Category.getInstance(DefaultSpaceLicenseManager.class);
    private BandanaManager bandanaManager;
    private SpaceManager spaceManager;

    public int getUserLimit(String spaceKey) {
        License license = this.getLicenseForSpace(spaceKey);
        if (license != null) {
            return license.getUsers();
        }
        return -1;
    }

    public License getLicenseForSpace(String spaceKey) {
        String licenseKey = this.getLicenseKeyForSpace(spaceKey);
        if (licenseKey == null) {
            return null;
        }
        return this.constructLicenseFromKey(licenseKey);
    }

    public String getLicenseKeyForSpace(String spaceKey) {
        ConfluenceBandanaContext ctx = new ConfluenceBandanaContext(spaceKey);
        String licenseKey = (String)this.bandanaManager.getValue((BandanaContext)ctx, "space.license");
        if (licenseKey == null) {
            licenseKey = (String)this.bandanaManager.getValue((BandanaContext)ctx, "evaluation.license");
        }
        if (licenseKey == null) {
            return null;
        }
        return licenseKey;
    }

    public void setLicenseOnSpace(String spaceKey, String licenseKey) throws LicenseException {
        if (licenseKey != null && !this.hasValidLicense(licenseKey)) {
            throw new LicenseException("License key not valid");
        }
        ConfluenceBandanaContext ctx = new ConfluenceBandanaContext(spaceKey);
        this.bandanaManager.setValue((BandanaContext)ctx, "space.license", (Object)licenseKey);
    }

    public void removeLicenseFromSpace(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        ConfluenceBandanaContext ctx = new ConfluenceBandanaContext(spaceKey);
        this.bandanaManager.setValue((BandanaContext)ctx, "space.license", null);
        this.bandanaManager.setValue((BandanaContext)ctx, "evaluation.license", null);
    }

    private License constructLicenseFromKey(String licenseString) {
        License license = null;
        String applicationName = "CONF";
        LicensePair pair = null;
        try {
            pair = new LicensePair(licenseString);
            license = LicenseDecoder.getLicense((LicensePair)pair, (String)applicationName);
        }
        catch (Exception e) {
            log.error((Object)("Invalid license: " + licenseString), (Throwable)e);
        }
        return license;
    }

    private boolean hasValidLicense(String licenseKey) {
        String applicationName = "CONF";
        LicensePair pair = null;
        try {
            pair = new LicensePair(licenseKey);
            License updatedLicense = LicenseDecoder.getLicense((LicensePair)pair, (String)applicationName);
            return LicenseDecoder.isValid((LicensePair)pair, (String)applicationName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setMessageManager(MessageManager messageManager) {
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

