/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceGroup;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.hibernate.Hibernate;
import org.apache.log4j.Category;

public class Space
extends ConfluenceEntityObject
implements Searchable {
    public static final String PERSONAL_SPACEKEY_IDENTIFIER = "~";
    protected static Category log = Category.getInstance(Space.class);
    private String name;
    private String key;
    private SpaceType spaceType = SpaceType.GLOBAL;
    private SpaceDescription description;
    private Page homePage;
    private List permissions = new ArrayList();
    private List pageTemplates = new ArrayList();
    private SpaceGroup spaceGroup;
    private transient SpaceManager spaceManager;

    public static boolean isValidSpaceKey(String key) {
        if (!TextUtils.stringSet((String)key)) {
            return false;
        }
        if (key.startsWith(PERSONAL_SPACEKEY_IDENTIFIER)) {
            return Space.isValidPersonalSpaceKey(key);
        }
        return Space.isValidGlobalSpaceKey(key);
    }

    public static boolean isValidGlobalSpaceKey(String key) {
        return TextUtils.stringSet((String)key) && GeneralUtil.isAllAscii(key) && GeneralUtil.isAllLettersOrNumbers(key);
    }

    public static boolean isValidPersonalSpaceKey(String key) {
        return TextUtils.stringSet((String)key) && key.indexOf(PERSONAL_SPACEKEY_IDENTIFIER) == 0;
    }

    public Space() {
    }

    public Space(String spaceKey) {
        this.setKey(spaceKey);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public SpaceType getType() {
        return this.spaceType;
    }

    public SpaceType getSpaceType() {
        return this.spaceType;
    }

    public void setSpaceType(SpaceType spaceType) {
        this.spaceType = spaceType;
    }

    public SpaceDescription getDescription() {
        return this.description;
    }

    public void setDescription(SpaceDescription description) {
        this.description = description;
    }

    public Page getHomePage() {
        return this.homePage;
    }

    public void setHomePage(Page homePage) {
        this.homePage = homePage;
    }

    public List getPages() {
        return this.getSpaceManager().getPages(this, false);
    }

    public List getCurrentPages() {
        return this.getSpaceManager().getPages(this, true);
    }

    private void setPages(List pages) {
    }

    public List getBlogPosts() {
        return this.getSpaceManager().getBlogPosts(this, false);
    }

    public List getCurrentBlogPosts() {
        return this.getSpaceManager().getBlogPosts(this, true);
    }

    private void setBlogPosts(List c) {
    }

    public List getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List permissions) {
        this.permissions = permissions;
    }

    public void addPermission(SpacePermission permission) {
        this.getPermissions().add(permission);
        permission.setSpace(this);
    }

    public void removePermission(SpacePermission permission) {
        this.getPermissions().remove(permission);
        permission.setSpace(null);
    }

    public List getPageTemplates() {
        return this.pageTemplates;
    }

    private void setPageTemplates(List pageTemplates) {
        this.pageTemplates = pageTemplates;
    }

    public void addPageTemplate(PageTemplate pageTemplate) {
        this.getPageTemplates().add(pageTemplate);
        pageTemplate.setSpace(this);
    }

    public void removePageTemplate(PageTemplate pageTemplate) {
        this.getPageTemplates().remove(pageTemplate);
        pageTemplate.setSpace(null);
    }

    public List getMail() {
        return this.getSpaceManager().getMail(this, false);
    }

    public List getCurrentMail() {
        return this.getSpaceManager().getMail(this, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Space space = (Space)o;
        if (this.getSpaceType() != null ? !this.getSpaceType().equals(space.getSpaceType()) : space.getSpaceType() != null) {
            return false;
        }
        if (this.getKey() != null ? !this.getKey().equalsIgnoreCase(space.getKey()) : space.getKey() != null) {
            return false;
        }
        return !(this.getName() != null ? !this.getName().equals(space.getName()) : space.getName() != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 29 * result + (this.getKey() != null ? this.getKey().toLowerCase().hashCode() : 0);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Space clone = (Space)super.clone();
        if (this.getDescription() != null) {
            clone.setDescription((SpaceDescription)this.getDescription().clone());
        }
        return clone;
    }

    public Collection getSearchableDependants() {
        return Collections.EMPTY_LIST;
    }

    public boolean isIndexable() {
        return true;
    }

    private SpaceManager getSpaceManager() {
        if (this.spaceManager == null) {
            this.spaceManager = (SpaceManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"spaceManager");
        }
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public String getUrlPath() {
        return "/display/" + this.key;
    }

    public boolean isPersonal() {
        return SpaceType.isPersonal(this);
    }

    public boolean isGlobal() {
        return SpaceType.isGlobal(this);
    }

    public SpaceGroup getSpaceGroup() {
        return this.spaceGroup;
    }

    public void setSpaceGroup(SpaceGroup spaceGroup) {
        this.spaceGroup = spaceGroup;
    }
}

