/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;

public class SpaceDescription
extends SpaceContentEntityObject {
    public static final String CONTENT_TYPE_SPACEDESC = "spacedesc";
    public static final String CONTENT_TYPE_PERSONAL_SPACEDESC = "personalspacedesc";

    public SpaceDescription() {
    }

    public SpaceDescription(Space space) {
        this.setSpace(space);
    }

    public String getDisplayTitle() {
        if (this.getOriginalVersion() != null) {
            return ((ContentEntityObject)this.getOriginalVersion()).getDisplayTitle();
        }
        if (this.getSpace() == null) {
            return "Orphaned Space Description";
        }
        return this.getSpace().getName();
    }

    public String getUrlPath() {
        if (this.getSpace() != null && this.getSpace().isPersonal()) {
            return this.getSpace().getUrlPath();
        }
        return "/spaces/viewspacesummary.action?key=" + (this.getSpace() != null ? this.getSpace().getKey() : "");
    }

    public String getType() {
        if (this.isPersonalSpace()) {
            return CONTENT_TYPE_PERSONAL_SPACEDESC;
        }
        return CONTENT_TYPE_SPACEDESC;
    }

    public String getSpaceKey() {
        return this.getSpace().getKey();
    }

    public boolean isPersonalSpace() {
        Space space = ((SpaceDescription)this.getLatestVersion()).getSpace();
        return space != null && SpaceType.PERSONAL.equals(space.getSpaceType());
    }
}

