/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceGroup;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.user.User;
import java.util.Date;
import java.util.List;

public interface SpaceManager {
    public static final String PERSONAL_SPACEKEY_IDENTIFIER = "~";

    public Space createSpace(String var1, String var2, String var3, User var4);

    public Space createPersonalSpace(String var1, String var2, User var3);

    public void saveSpace(Space var1);

    public void saveSpace(Space var1, Space var2);

    public void removeSpace(Space var1);

    public void removeSpacesInGroup(SpaceGroup var1);

    public Space getSpace(long var1);

    public Space getSpace(String var1);

    public Space getPersonalSpace(String var1);

    public Space getPersonalSpace(User var1);

    public List getAllSpaces();

    public List getSpaces();

    public List getPermittedSpaces(User var1);

    public List getPermittedSpacesByType(User var1, SpaceType var2);

    public List getPermittedSpacesInSpaceGroup(User var1, SpaceGroup var2);

    public List getSpacesEditableByUser(User var1);

    public List getEditableSpacesByType(User var1, SpaceType var2);

    public List getSpacesContainingPagesEditedBy(String var1);

    public List getSpacesContainingCommentsBy(String var1);

    public List getAuthoredSpacesByUser(String var1);

    public List getSpacesCreatedOrUpdatedSinceDate(Date var1);

    public void convertToPersonalSpace(Space var1, User var2, boolean var3);

    public long findPageTotal(Space var1);

    public int getNumberOfBlogPosts(Space var1);

    public int getNumberOfMail(Space var1);

    public void moveHierarchy(Page var1, Page var2, Space var3, User var4, boolean var5, List var6);

    public String getSpaceFromPageId(long var1);

    public List getSpaceContent(Space var1, boolean var2);

    public List getSpacesCreatedAfter(Date var1);

    public String getPersonalSpaceKey(String var1);

    public List getSpacesByType(SpaceType var1);

    public List getSpacesInSpaceGroup(SpaceGroup var1);

    public boolean isValidSpaceKey(String var1);

    public boolean isValidPersonalSpaceKey(String var1);

    public List getPages(Space var1, boolean var2);

    public List getPagesStartingWith(Space var1, String var2);

    public List getBlogPosts(Space var1, boolean var2);

    public List getMail(Space var1, boolean var2);

    public void ensureSpaceDescriptionExists(Space var1);
}

