/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.atlassian.confluence.spaces.actions.Spaced;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractSpaceAction
extends ConfluenceActionSupport
implements Spaced {
    private static final Logger log = Logger.getLogger(AbstractSpaceAction.class);
    protected SpaceManager spaceManager;
    protected String key;
    protected Space space;
    protected Space originalSpace;
    protected WikiStyleRenderer wikiStyleRenderer;
    protected NotificationManager notificationManager;

    public String getKey() {
        return this.key;
    }

    public String getSpaceKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key.trim();
        this.space = null;
    }

    public boolean isValidSpaceKey() {
        return Space.isValidSpaceKey(this.key);
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public Space getSpace() {
        if (this.space == null && this.isValidSpaceKey()) {
            this.space = this.spaceManager.getSpace(this.key);
            if (this.space != null) {
                try {
                    this.originalSpace = (Space)this.space.clone();
                }
                catch (CloneNotSupportedException e) {
                    log.error((Object)("Could not clone space?" + e), (Throwable)e);
                }
            }
        }
        return this.space;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    protected List getPermissionTypes() {
        List<String> permissionTypes = super.getPermissionTypes();
        if (this.getSpace() != null) {
            this.addPermissionTypeTo("VIEWSPACE", permissionTypes);
            if (this instanceof SpaceAdministrative) {
                this.addPermissionTypeTo("SETSPACEPERMISSIONS", permissionTypes);
            }
        }
        return permissionTypes;
    }

    public boolean isPermitted() {
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        return this.spacePermissionManager.hasPermission(this.getPermissionTypes(), this.getSpace(), this.getRemoteUser());
    }

    public boolean isSuperUser() {
        return GeneralUtil.isSuperUser(this.getRemoteUser());
    }

    public boolean isAdminUser() {
        return GeneralUtil.isSuperUser(this.getRemoteUser()) || this.spacePermissionManager.hasPermission(Arrays.asList("SETSPACEPERMISSIONS"), this.getSpace(), this.getRemoteUser());
    }

    public String getSubscribableName() {
        return this.getKey();
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    @HtmlSafe
    public String getSpaceXHtmlDescription() {
        Space space = this.getSpace();
        if (space == null) {
            return "";
        }
        if (space.getDescription() != null) {
            return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)this.getSpace().getDescription().toPageContext(), this.getSpace().getDescription().getContent());
        }
        return "";
    }

    public boolean isUserWatchingSpace() {
        if (this.isAnonymousUser()) {
            return false;
        }
        return this.notificationManager.getNotificationByUserAndSpace(this.getRemoteUser(), this.getSpaceKey()) != null;
    }

    public boolean isPersonalSpace() {
        return this.getSpace().isPersonal();
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }
}

