/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.AbstractCreateSpaceAction;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import com.opensymphony.webwork.ServletActionContext;
import org.apache.commons.lang.StringUtils;

public class CreatePersonalSpaceAction
extends AbstractCreateSpaceAction {
    public String execute() throws Exception {
        User creator = this.getRemoteUser();
        String name = this.getRemoteUser().getFullName();
        this.space = this.spaceManager.createPersonalSpace(name, this.description, creator);
        this.permissionSetter.setSpacePermissionManager(this.spacePermissionManager);
        this.permissionSetter.setSpace(this.space);
        this.permissionSetter.execute();
        this.indexManager.flushQueue();
        return super.execute();
    }

    public String doDefault() throws Exception {
        this.getPermissionSetter().setRegisteredCanView(true);
        this.getPermissionSetter().setAnonymousCanView(false);
        this.getPermissionSetter().setRegisteredCanEdit(false);
        this.getPermissionSetter().setAnonymousCanEdit(false);
        if (this.getRemoteUser() != null && StringUtils.isBlank((String)this.getRemoteUser().getFullName())) {
            String contextPath = ServletActionContext.getRequest().getContextPath();
            this.addActionError(this.getText("personal.space.error.fullname.blank", new String[]{contextPath}));
            return "error";
        }
        return super.doDefault();
    }

    public boolean isPermitted() {
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        return this.getRemoteUser() != null && this.permissionManager.hasCreatePermission(this.getRemoteUser(), this.getPersonalInformation(this.getRemoteUser()), Space.class);
    }

    public String getUsername() {
        return this.getRemoteUser().getName();
    }

    private PersonalInformation getPersonalInformation(User remoteUser) {
        return this.personalInformationManager.getPersonalInformation(remoteUser);
    }
}

