/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceGroup;
import com.atlassian.confluence.spaces.SpaceGroupManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.actions.AbstractCreateSpaceAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.SpaceGroupComparator;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

public class CreateSpaceAction
extends AbstractCreateSpaceAction {
    private String name;
    private String spaceGroup;
    protected SpaceGroupManager spaceGroupManager;
    private Settings settings;
    private String message;
    private boolean result;

    public String doDefault() throws Exception {
        this.getPermissionSetter().setRegisteredCanView(true);
        this.getPermissionSetter().setAnonymousCanView(false);
        this.getPermissionSetter().setRegisteredCanEdit(true);
        this.getPermissionSetter().setAnonymousCanEdit(false);
        return super.doDefault();
    }

    public void validate() {
        if (!Space.isValidGlobalSpaceKey(this.getKey())) {
            this.addFieldError("key", this.getText("space.key.invalid"));
        }
        if (this.spaceManager.getSpace(this.key) != null) {
            this.addFieldError("key", this.getText("space.key.exists"));
        }
        if (!TextUtils.stringSet((String)this.name)) {
            this.addFieldError("name", this.getText("space.name.empty"));
        }
        if (!TextUtils.stringSet((String)this.spaceGroup) && this.settings.isSharedMode()) {
            this.addFieldError("spaceGroup", this.getText("space.group.empty"));
        }
        if (TextUtils.stringSet((String)this.spaceGroup) && this.spaceGroupManager.getSpaceGroup(this.spaceGroup) == null) {
            this.addFieldError("spaceGroup", this.getText("space.group.unknown"));
        }
        super.validate();
    }

    public String execute() throws Exception {
        User creator = this.getRemoteUser();
        this.space = this.spaceManager.createSpace(this.key, this.name, this.description, creator);
        if (TextUtils.stringSet((String)this.spaceGroup)) {
            SpaceGroup sg = this.spaceGroupManager.getSpaceGroup(this.spaceGroup);
            this.space.setSpaceGroup(sg);
        }
        this.permissionSetter.setSpacePermissionManager(this.spacePermissionManager);
        this.permissionSetter.setSpace(this.space);
        this.permissionSetter.execute();
        this.indexManager.flushQueue();
        return super.execute();
    }

    public String spaceKeyAvailable() {
        this.result = true;
        if (!this.isValidSpaceKey()) {
            this.message = this.getText("space.key.invalid");
            this.result = false;
        } else if (this.spaceManager.getSpace(this.key) != null) {
            this.message = this.getText("space.key.exists");
            this.result = false;
        }
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("text/xml");
        return "success";
    }

    public List getPermissionTypes() {
        List permissionTypes = super.getPermissionTypes();
        this.addPermissionTypeTo("CREATESPACE", permissionTypes);
        return permissionTypes;
    }

    public boolean isPermitted() {
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        return this.spacePermissionManager.hasPermission(this.getPermissionTypes(), this.getSpace(), this.getRemoteUser());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSpaceGroupManager(SpaceGroupManager spaceGroupManager) {
        this.spaceGroupManager = spaceGroupManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settings = settingsManager.getGlobalSettings();
    }

    public void setSpaceGroup(String spaceGroup) {
        this.spaceGroup = spaceGroup;
    }

    public String getSpaceGroup() {
        return this.spaceGroup;
    }

    public List getSpaceGroups() {
        ArrayList<SpaceGroup> spaceGroups = null;
        if (this.settings.isSharedMode()) {
            HashSet<SpaceGroup> uniqueSpaceGroups = new HashSet<SpaceGroup>();
            List allSpaces = this.spaceManager.getPermittedSpacesByType(this.getRemoteUser(), SpaceType.GLOBAL);
            for (Space space : allSpaces) {
                if (space.getSpaceGroup() == null) continue;
                uniqueSpaceGroups.add(space.getSpaceGroup());
            }
            spaceGroups = new ArrayList<SpaceGroup>(uniqueSpaceGroups);
        } else {
            spaceGroups = this.spaceGroupManager.getSpaceGroups();
        }
        Collections.sort(spaceGroups, new SpaceGroupComparator());
        if (!this.settings.isSharedMode()) {
            SpaceGroup none = new SpaceGroup("");
            none.setName(this.getText("enter.space.group.none"));
            spaceGroups.add(0, none);
        }
        return spaceGroups;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }
}

