/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.opensymphony.util.FileUtils;
import java.io.File;
import java.io.FileFilter;
import org.apache.log4j.Logger;

public class ImportPagesAction
extends AbstractSpaceAction
implements SpaceAdministrative {
    private static final Logger log = Logger.getLogger(ImportPagesAction.class);
    private String directory = null;
    private PageManager pageManager;
    private boolean trimExtension;
    private boolean overwriteExisting;

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public boolean isTrimExtension() {
        return this.trimExtension;
    }

    public void setTrimExtension(boolean trimExtension) {
        this.trimExtension = trimExtension;
    }

    public boolean isOverwriteExisting() {
        return this.overwriteExisting;
    }

    public void setOverwriteExisting(boolean overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean isValidDirectory() {
        File dir = new File(this.directory);
        return dir.exists() && dir.isDirectory() && dir.canRead();
    }

    public String doDefault() throws Exception {
        if (this.isPersonalSpace()) {
            return "pagenotfound";
        }
        return super.doDefault();
    }

    public String execute() throws Exception {
        if (this.isPersonalSpace()) {
            return "pagenotfound";
        }
        File dirFile = new File(this.directory);
        File[] files = dirFile.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile();
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                this.createPage(file);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("An error occurred importing: " + file), (Throwable)e);
            }
        }
        if (this.hasErrors()) {
            return "error";
        }
        return "success";
    }

    private void createPage(File file) {
        Page page = null;
        String title = this.getBaseTitle(file);
        String content = FileUtils.readFile((File)file);
        content = content.replaceAll(String.valueOf('\u0000'), "");
        page = this.pageManager.getPage(this.key, title);
        if (this.overwriteExisting && page != null) {
            page.setContent(content);
            this.pageManager.saveContentEntity(page, null);
            return;
        }
        if (page != null) {
            title = this.getNonClashingTitle(title);
        }
        page = new Page();
        page.setTitle(title);
        page.setContent(content);
        page.setSpace(this.getSpace());
        this.pageManager.saveContentEntity(page, null);
    }

    private String getBaseTitle(File file) {
        int extStart;
        String title = file.getName();
        if (this.isTrimExtension() && (extStart = title.lastIndexOf(46)) > 0) {
            title = title.substring(0, extStart);
        }
        return title;
    }

    private String getNonClashingTitle(String clashingTitle) {
        Page existingPage = this.pageManager.getPage(this.key, clashingTitle);
        String title = clashingTitle;
        if (existingPage != null) {
            int suffix = 1;
            while (existingPage != null) {
                title = clashingTitle + suffix++;
                existingPage = this.pageManager.getPage(this.key, title);
            }
        }
        return title;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

