/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.actions.SearchBean;
import com.atlassian.confluence.search.actions.SearchQueryBean;
import com.atlassian.confluence.search.scope.SpaceScope;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.spring.container.ContainerManager;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;

public class ListAttachmentsAction
extends AbstractSpaceAction {
    private SearchBean searchBean;
    private int startIndex;
    private String sortBy;
    private String fileExtension;
    private SearchQueryBean searchQueryBean;
    private static final String PLUGIN_KEY = "space-attachments";
    private static final int COUNT_ON_EACH_PAGE = 20;

    public String execute() throws Exception {
        GeneralUtil.setCookie("confluence.browse.space.cookie", PLUGIN_KEY);
        this.initialiseAttachments();
        return "success";
    }

    private void initialiseAttachments() {
        BooleanQuery query = new BooleanQuery();
        new SpaceScope(this.getSpaceKey(), this.labelManager).restrictQuery(null, query);
        this.getSearchQueryBean().addClassSearchField(query, Attachment.class.getName());
        if (StringUtils.isNotBlank((String)this.getFileExtension())) {
            query.add((Query)new TermQuery(new Term("file.extension", this.getFileExtension())), BooleanClause.Occur.MUST);
        }
        PaginationSupport paginationSupport = new PaginationSupport(20);
        paginationSupport.setStartIndex(this.startIndex);
        this.searchBean.setPaginationSupport(paginationSupport);
        this.searchBean.search((Query)query, null, this.getSort());
    }

    private Sort getSort() {
        if ("date".equals(this.sortBy)) {
            return new Sort("modified", true);
        }
        if ("size".equals(this.sortBy)) {
            return new Sort("filesize", true);
        }
        return new Sort("filenameuntokenized");
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension.startsWith(".") ? fileExtension.substring(1).toLowerCase() : fileExtension.toLowerCase();
    }

    public SearchQueryBean getSearchQueryBean() {
        if (this.searchQueryBean == null) {
            this.searchQueryBean = new SearchQueryBean();
            ContainerManager.autowireComponent((Object)this.searchQueryBean);
        }
        return this.searchQueryBean;
    }

    public void setSearchBean(SearchBean searchBean) {
        this.searchBean = searchBean;
    }

    public PaginationSupport getPaginationSupport() {
        return this.searchBean.getPaginationSupport();
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }
}

