/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.listeners;

import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.opensymphony.util.TextUtils;
import java.text.MessageFormat;
import org.apache.log4j.Category;

public class InitialSpaceContentListener
implements EventListener {
    private static final Category log = Category.getInstance(InitialSpaceContentListener.class);
    public static final String DEFAULT_HOMEPAGE_TITLE = "Home";
    public static final String DEFAULT_HOMEPAGE_CONTENT = "This is the home page for the {0} space.";
    public static final String DEFAULT_INDEX_TITLE = "Index";
    public static final String DEFAULT_INDEX_CONTENT = "{index}";
    private static final Class[] HANDLED_EVENTS = new Class[]{SpaceCreateEvent.class};
    private PageManager pageManager;
    private SettingsManager settingsManager;
    private PersonalInformationManager personalInformationManager;

    public void handleEvent(Event event) {
        if (!(event instanceof SpaceCreateEvent)) {
            throw new IllegalArgumentException("Expecting a SpaceCreateEvent or SpaceConvertEvent, got a " + event.getClass().getName());
        }
        this.handleSpaceCreate(event);
    }

    protected void handleSpaceCreate(Event event) {
        SpaceCreateEvent spaceCreateEvent = (SpaceCreateEvent)event;
        Space space = spaceCreateEvent.getSpace();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating initial space content for " + space));
        }
        Page homePage = this.createHomePage(space);
        this.pageManager.saveContentEntity(homePage, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finished creating initial space content for " + space));
        }
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    private Page createHomePage(Space space) {
        PersonalInformation personalInfo;
        String spaceKey;
        Page homePage = new Page();
        Settings globalSettings = this.settingsManager.getGlobalSettings();
        homePage.setTitle(TextUtils.noNull((String)globalSettings.getDefaultSpaceHomepageTitle(), (String)DEFAULT_HOMEPAGE_TITLE));
        String homePageContent = this.getDefaultHomePageContent(space, globalSettings);
        if (space.isPersonal() && Space.isValidPersonalSpaceKey(spaceKey = space.getKey()) && (personalInfo = this.personalInformationManager.getPersonalInformation(this.getUsernameFromPersonalSpaceKey(spaceKey))) != null && TextUtils.stringSet((String)personalInfo.getContent())) {
            homePageContent = personalInfo.getContent();
        }
        homePage.setContent(homePageContent);
        homePage.setSpace(space);
        space.setHomePage(homePage);
        return homePage;
    }

    private String getDefaultHomePageContent(Space space, Settings globalSettings) {
        String defaultSpaceHomeContent = space.isPersonal() ? globalSettings.getDefaultPersonalSpaceHomepageContent() : globalSettings.getDefaultSpaceHomepageContent();
        defaultSpaceHomeContent = TextUtils.noNull((String)defaultSpaceHomeContent, (String)DEFAULT_HOMEPAGE_CONTENT);
        return MessageFormat.format(defaultSpaceHomeContent, space.getName());
    }

    private String getUsernameFromPersonalSpaceKey(String spaceKey) {
        return spaceKey.substring("~".length());
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }
}

