/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.persistence.dao.hibernate;

import com.atlassian.cache.Cache;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.confluence.cache.CacheManagerKeys;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceGroup;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.persistence.dao.SpaceDao;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.user.Entity;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateSpaceDao
extends ConfluenceHibernateObjectDao
implements SpaceDao {
    private HibernateConfig hibernateConfig;
    private UserAccessor userAccessor;

    public List findAllGlobalSpaces() {
        return this.findNamedQuery("confluence.space_findAll", true);
    }

    public List findAllSpacesSorted(String sortField, final SpaceType type) {
        final String finalQuery = this.buildSortedSpacesQuery(sortField);
        List result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(finalQuery);
                queryObject.setParameter("spaceType", (Object)type.toString());
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateSpaceDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    private String buildSortedSpacesQuery(String sortField) {
        StringBuffer query = new StringBuffer();
        query.append("FROM ").append(this.getPersistentClass().getName()).append(" result");
        query.append(" WHERE result.spaceType = :spaceType");
        if (Versioned.class.isAssignableFrom(this.getPersistentClass())) {
            query.append(" AND result.originalVersion is null");
        }
        if (sortField != null) {
            query.append(" ORDER BY LOWER(result.").append(sortField).append(")");
        }
        return query.toString();
    }

    protected EntityObject getByClassId(long l) {
        return super.getByClassId(l);
    }

    public Space getById(long id) {
        Space locatedSpace = (Space)this.getByClassId(id);
        if (locatedSpace != null) {
            this.cacheSpaceIdBySpaceKey(locatedSpace.getKey(), locatedSpace.getId());
        }
        return locatedSpace;
    }

    public Space getSpace(String spaceKey) {
        Space locatedSpace;
        if (spaceKey == null) {
            return null;
        }
        Long spaceId = this.getCachedSpaceId(spaceKey = spaceKey.toLowerCase());
        if (spaceId == null) {
            locatedSpace = (Space)this.findSingleObject(this.findNamedQueryStringParam("confluence.space_findBySpaceKey", "spaceKey", spaceKey.toLowerCase(), true));
            if (locatedSpace == null) {
                return null;
            }
        } else {
            Space locatedSpace2 = this.getById(spaceId);
            if (locatedSpace2 != null && locatedSpace2.getKey() != null && locatedSpace2.getKey().toLowerCase().equals(spaceKey)) {
                return locatedSpace2;
            }
            log.error((Object)("Found a bad space id in the space id cache which returned this: " + locatedSpace2 + ". Removing this id from the cache now."));
            try {
                this.getCache().remove((Object)spaceKey);
            }
            catch (Exception e) {
                log.error((Object)("Unable to remove spaceKey [" + spaceKey + "] from cache"), (Throwable)e);
            }
            return (Space)this.findSingleObject(this.findNamedQueryStringParam("confluence.space_findBySpaceKey", "spaceKey", spaceKey.toLowerCase(), true));
        }
        this.cacheSpaceIdBySpaceKey(spaceKey, locatedSpace.getId());
        return locatedSpace;
    }

    public List getSpacesInSpaceGroup(SpaceGroup spaceGroup) {
        return this.findNamedQueryStringParam("confluence.space_findSpacesBySpaceGroup", "spaceGroupKey", GeneralUtil.specialToLowerCase(spaceGroup.getKey()));
    }

    private Cache getCache() {
        return this.cacheFactory.getCache(CacheManagerKeys.CACHE_KEY_SPACE_KEY_TO_SPACEID);
    }

    public List getSpacesCreatedByUser(String username) {
        return this.findNamedQueryStringParam("confluence.space_findByCreator", "creatorName", GeneralUtil.specialToLowerCase(username));
    }

    public List getSpacesContainingPagesEditedByUser(String username) {
        return this.findNamedQueryStringParam("confluence.space_findByPageEditor", "name", GeneralUtil.specialToLowerCase(username));
    }

    public List getSpacesContainingCommentsByUser(String username) {
        if (this.hibernateConfig.isMySql()) {
            return this.mySqlGetSpacesContainingCommentsByUser(username);
        }
        List abstractPages = this.findNamedQueryStringParam("confluence.pages_findByCommentAuthor", "name", GeneralUtil.specialToLowerCase(username));
        ArrayList result = new ArrayList();
        HashSet<Space> distinctSpaces = new HashSet<Space>();
        for (AbstractPage abstractPage : abstractPages) {
            if (!abstractPage.getSpace().isGlobal()) continue;
            distinctSpaces.add(abstractPage.getSpace());
        }
        result.addAll(distinctSpaces);
        return result;
    }

    private List mySqlGetSpacesContainingCommentsByUser(String username) {
        int maxSpaces = this.findAll().size();
        HashSet<Space> spaces = new HashSet<Space>();
        List allComments = this.findNamedQueryStringParam("confluence.comment_findByUsername", "username", username.toLowerCase());
        for (Comment comment : allComments) {
            spaces.add(comment.getPage().getSpace());
            if (spaces.size() != maxSpaces) continue;
            return new ArrayList(spaces);
        }
        return new ArrayList(spaces);
    }

    public List getSpacesCreatedOrUpdatedSinceDate(Date previousLoginDate) {
        return this.findNamedQueryStringParam("confluence.space_findSpacesCreatedOrUpdatedSinceDate", "date", previousLoginDate, false);
    }

    public int findPageTotal(final Space space) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("confluence.space_getPageCount");
                query.setParameter("spaceid", (Object)new Long(space.getId()));
                return query.iterate().next();
            }
        });
    }

    private Long getCachedSpaceId(String spaceKey) {
        try {
            Object value = this.getCache().get((Object)spaceKey);
            if (value != null) {
                return (Long)value;
            }
            return null;
        }
        catch (InfrastructureException e) {
            log.error((Object)"Error while trying to fetch cached permission check result from to the cache!", (Throwable)e);
            return null;
        }
    }

    private void cacheSpaceIdBySpaceKey(String spaceKey, long spaceId) {
        this.getCache().put((Object)spaceKey.toLowerCase(), (Object)new Long(spaceId));
    }

    private void removeSpaceFromCache(Space space) throws Exception {
        this.getCache().remove((Object)space.getKey().toLowerCase());
    }

    public void remove(EntityObject entity) {
        if (entity instanceof Space) {
            Space space = (Space)entity;
            try {
                this.removeSpaceFromCache(space);
            }
            catch (Exception e) {
                log.error((Object)("Unable to remove Space [" + space + "] from cache"), (Throwable)e);
            }
        } else {
            log.error((Object)("SpaceDao was asked to delete a: " + entity.getClass().getName()), (Throwable)new Exception("Recording Stack Trace"));
        }
        super.remove(entity);
    }

    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public Class getPersistentClass() {
        return Space.class;
    }

    public int getNumberOfBlogPosts(final Space space) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("confluence.space_getBlogPostCount");
                query.setParameter("spaceid", (Object)new Long(space.getId()));
                return query.iterate().next();
            }
        });
    }

    public int getNumberOfMail(final Space space) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("confluence.space_getMailCount");
                query.setParameter("spaceid", (Object)new Long(space.getId()));
                return query.iterate().next();
            }
        });
    }

    public List getSpacesCreatedAfter(final Date creationDate) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("confluence.space_getSpacesCreatedAfter");
                query.setParameter("creationDate", (Object)creationDate);
                return query.list();
            }
        });
    }

    public List getPermittedSpacesForUser(final User user, final String permission) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query;
                if (user != null) {
                    List userGroups = HibernateSpaceDao.this.getUserAccessor().getGroupsAsList(user);
                    if (userGroups.isEmpty()) {
                        query = session.getNamedQuery("confluence.space_getPermittedSpacesForUserNotInAnyGroup");
                    } else {
                        query = session.getNamedQuery("confluence.space_getPermittedSpacesForUser");
                        query.setParameterList("groups", (Collection)HibernateSpaceDao.toListOfEntityNames(userGroups));
                    }
                    query.setParameter("username", (Object)user.getName());
                } else {
                    query = session.getNamedQuery("confluence.space_getPermittedSpacesForAnonymousUser");
                }
                query.setParameter("permission", (Object)permission);
                return query.list();
            }
        });
    }

    public List getPermittedSpacesForUserByType(final User user, final String permission, final SpaceType type) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query;
                if (user != null) {
                    List userGroups = HibernateSpaceDao.this.getUserAccessor().getGroupsAsList(user);
                    if (userGroups.isEmpty()) {
                        query = session.getNamedQuery("confluence.space_getPermittedSpacesForUserNotInAnyGroupByType");
                    } else {
                        query = session.getNamedQuery("confluence.space_getPermittedSpacesForUserByType");
                        query.setParameterList("groups", (Collection)HibernateSpaceDao.toListOfEntityNames(userGroups));
                    }
                    query.setParameter("username", (Object)user.getName());
                } else {
                    query = session.getNamedQuery("confluence.space_getPermittedSpacesForAnonymousUserByType");
                }
                query.setParameter("type", (Object)type.toString());
                query.setParameter("permission", (Object)permission);
                return query.list();
            }
        });
    }

    public List getPermittedSpacesForUserInSpaceGroup(final User user, final String permission, final SpaceGroup spaceGroup) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query;
                if (user != null) {
                    List userGroups = HibernateSpaceDao.this.getUserAccessor().getGroupsAsList(user);
                    if (userGroups.isEmpty()) {
                        query = session.getNamedQuery("confluence.space_getPermittedSpacesForUserNotInAnyGroupBySpaceGroup");
                    } else {
                        query = session.getNamedQuery("confluence.space_getPermittedSpacesForUserBySpaceGroup");
                        query.setParameterList("groups", (Collection)HibernateSpaceDao.toListOfEntityNames(userGroups));
                    }
                    query.setParameter("username", (Object)user.getName());
                } else {
                    query = session.getNamedQuery("confluence.space_getPermittedSpacesForAnonymousUserBySpaceGroup");
                }
                query.setParameter("spaceGroupId", (Object)new Long(spaceGroup.getId()));
                query.setParameter("permission", (Object)permission);
                return query.list();
            }
        });
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    private static List toListOfEntityNames(List entities) {
        ArrayList<String> entityNames = new ArrayList<String>();
        for (Entity e : entities) {
            if (e == null) {
                log.error((Object)"null entity in list");
                continue;
            }
            entityNames.add(e.getName());
        }
        return entityNames;
    }
}

