/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.status.service.systeminfo;

import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.util.i18n.DefaultI18NBeanFactory;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.core.util.DateUtils;
import com.atlassian.plugin.Plugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfluenceInfo {
    private String home;
    private String buildNumber;
    private String version;
    private long startTime;
    private List<Plugin> enabledPlugins = Collections.emptyList();

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String getUpTime() {
        long currentTime = System.currentTimeMillis();
        I18NBean i18n = new DefaultI18NBeanFactory().getI18NBean();
        return DateUtils.dateDifference((long)this.getStartTime(), (long)currentTime, (long)4L, (ResourceBundle)i18n.getResourceBundle());
    }

    public List<Plugin> getEnabledPlugins() {
        return this.enabledPlugins;
    }

    public void setEnabledPlugins(Collection<Plugin> plugins) {
        if (plugins == null) {
            this.enabledPlugins = Collections.emptyList();
            return;
        }
        this.enabledPlugins = new ArrayList<Plugin>(plugins);
        Collections.sort(this.enabledPlugins, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin p1, Plugin p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
    }

    public boolean isDevMode() {
        return ConfluenceSystemProperties.isDevMode();
    }
}

