/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes;

import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.core.util.ClassLoaderUtils;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Category;

public class DefaultColourScheme
implements ColourScheme {
    private static final Category log = Category.getInstance(DefaultColourScheme.class);
    private static ColourScheme defaultColourScheme;
    private Properties defaultColours = new Properties();

    private DefaultColourScheme() {
        try {
            this.defaultColours.load(ClassLoaderUtils.getResourceAsStream((String)"confluence-default-colours.properties", DefaultColourScheme.class));
        }
        catch (IOException e) {
            log.error((Object)("Could not load default colours - couldn't find confluence-default-colours.properties:" + e), (Throwable)e);
        }
    }

    public static ColourScheme getInstance() {
        if (defaultColourScheme == null) {
            defaultColourScheme = new DefaultColourScheme();
        }
        return defaultColourScheme;
    }

    public String get(String colourName) {
        return (String)this.defaultColours.get(colourName);
    }
}

