/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.setup.settings.SpaceSettings;
import com.atlassian.confluence.setup.settings.beans.ColourSchemesSettings;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.BaseColourScheme;
import com.atlassian.confluence.themes.ChainedColourScheme;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.themes.DefaultColourScheme;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.themes.events.ColourSchemeChangedEvent;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import org.apache.log4j.Category;

public class DefaultColourSchemeManager
implements ColourSchemeManager {
    private static Category log = Category.getInstance(DefaultColourSchemeManager.class);
    BandanaManager bandanaManager;
    SettingsManager settingsManager;
    ThemeManager themeManager;
    private ColourScheme defaultColourScheme = DefaultColourScheme.getInstance();
    private EventManager eventManager;

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public ColourScheme getSpaceColourScheme(Space space) {
        if (space == null) {
            log.error((Object)"Trying to retrieve a space colour scheme for a null space.");
            return null;
        }
        return this.getSpaceColourScheme(space.getKey());
    }

    public ColourScheme getSpaceColourScheme(String spaceKey) {
        if (!TextUtils.stringSet((String)spaceKey)) {
            log.error((Object)"Trying to retrieve a space colour scheme for a null space.");
            return null;
        }
        ArrayList<ColourScheme> themeList = new ArrayList<ColourScheme>();
        ColourScheme selectedColourScheme = this.getSelectedScheme(spaceKey);
        if (selectedColourScheme != null) {
            themeList.add(selectedColourScheme);
        }
        themeList.add(this.getSelectedScheme(null));
        themeList.add(this.defaultColourScheme);
        return new ChainedColourScheme(themeList);
    }

    public ColourScheme getGlobalColourScheme() {
        ArrayList<ColourScheme> themeList = new ArrayList<ColourScheme>();
        ColourScheme selectedColourScheme = this.getSelectedScheme(null);
        if (selectedColourScheme != null) {
            themeList.add(selectedColourScheme);
        }
        themeList.add(this.defaultColourScheme);
        return new ChainedColourScheme(themeList);
    }

    private ColourScheme getSelectedScheme(String spaceKey) {
        ColourSchemesSettings schemeSettings = this.getColourSchemesSettings(spaceKey);
        if (schemeSettings.getColourSchemeType().equals("theme")) {
            Theme theme = TextUtils.stringSet((String)spaceKey) ? this.themeManager.getSpaceTheme(spaceKey) : this.themeManager.getGlobalTheme();
            if (theme != null && theme.getColourScheme() != null) {
                return theme.getColourScheme();
            }
        } else {
            if (schemeSettings.getColourSchemeType().equals("custom")) {
                if (TextUtils.stringSet((String)spaceKey)) {
                    return this.getSpaceColourSchemeIsolated(spaceKey);
                }
                return this.getGlobalColourSchemeIsolated();
            }
            if (schemeSettings.getColourSchemeType().equals("global") && spaceKey != null) {
                Theme theme = this.themeManager.getSpaceTheme(spaceKey);
                if (theme != null && theme.getColourScheme() != null) {
                    return theme.getColourScheme();
                }
                return this.getSelectedScheme(null);
            }
        }
        return null;
    }

    private ColourSchemesSettings getColourSchemesSettings(String spaceKey) {
        if (TextUtils.stringSet((String)spaceKey)) {
            return this.settingsManager.getSpaceSettings(spaceKey).getColourSchemesSettings();
        }
        return this.settingsManager.getGlobalSettings().getColourSchemesSettings();
    }

    public ColourScheme getThemeColourScheme() {
        Theme theme = this.themeManager.getGlobalTheme();
        if (theme == null) {
            return null;
        }
        return theme.getColourScheme();
    }

    public ColourScheme getSpaceThemeColourScheme(String spaceKey) {
        Theme theme = this.themeManager.getSpaceTheme(spaceKey);
        if (theme == null) {
            return null;
        }
        return theme.getColourScheme();
    }

    public BaseColourScheme getSpaceColourSchemeIsolated(String spaceKey) {
        BaseColourScheme colourScheme = (BaseColourScheme)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), "atlassian.confluence.colour.scheme", false);
        if (colourScheme == null) {
            colourScheme = new BaseColourScheme(this.defaultColourScheme);
        }
        return colourScheme;
    }

    public BaseColourScheme getGlobalColourSchemeIsolated() {
        BaseColourScheme colourScheme = (BaseColourScheme)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.colour.scheme");
        if (colourScheme == null) {
            colourScheme = new BaseColourScheme(this.defaultColourScheme);
        }
        return colourScheme;
    }

    public void resetColourScheme(Space space) {
        if (space == null) {
            this.saveGlobalColourScheme(null);
        } else {
            this.saveSpaceColourScheme(space, null);
        }
    }

    public synchronized void saveSpaceColourScheme(Space space, BaseColourScheme colourScheme) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), "atlassian.confluence.colour.scheme", (Object)colourScheme);
        this.eventManager.publishEvent((Event)new ColourSchemeChangedEvent(this, space.getKey()));
    }

    public synchronized void saveGlobalColourScheme(BaseColourScheme colourScheme) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.colour.scheme", (Object)colourScheme);
        this.eventManager.publishEvent((Event)new ColourSchemeChangedEvent(this));
    }

    public void setColourSchemeSetting(Space space, String value) {
        if (space == null) {
            Settings settings = this.settingsManager.getGlobalSettings();
            settings.getColourSchemesSettings().setColourSchemeType(value);
            this.settingsManager.updateGlobalSettings(settings);
            this.eventManager.publishEvent((Event)new ColourSchemeChangedEvent(this));
        } else {
            SpaceSettings settings = this.settingsManager.getSpaceSettings(space.getKey());
            settings.getColourSchemesSettings().setColourSchemeType(value);
            this.settingsManager.updateSpaceSettings(settings);
            this.eventManager.publishEvent((Event)new ColourSchemeChangedEvent(this, space.getKey()));
        }
    }

    public String getColourSchemeSetting(Space space) {
        if (space == null) {
            return this.settingsManager.getGlobalSettings().getColourSchemesSettings().getColourSchemeType();
        }
        return this.settingsManager.getSpaceSettings(space.getKey()).getColourSchemesSettings().getColourSchemeType();
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

