/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.plugin.descriptor.ThemeModuleDescriptor;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.themes.DefaultTheme;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.themes.events.ThemeChangedEvent;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upgrade.UpgradeManager;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;

public class DefaultThemeManager
implements ThemeManager {
    private static final Category log = Category.getInstance(DefaultThemeManager.class);
    private PluginAccessor pluginAccessor;
    private BandanaManager bandanaManager;
    private EventManager eventManager;
    private UpgradeManager upgradeManager;
    static final String THEME_KEY = "theme.key";

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public Theme getGlobalTheme() {
        return this.getTheme(this.getGlobalThemeKey());
    }

    public String getGlobalThemeKey() {
        Map themeSettings = this.getThemeSettings(new ConfluenceBandanaContext());
        return (String)themeSettings.get(THEME_KEY);
    }

    public Theme getSpaceTheme(String spaceKey) {
        String spaceThemeKey = this.getSpaceThemeKey(spaceKey);
        Theme theme = null;
        if (TextUtils.stringSet((String)spaceThemeKey)) {
            theme = this.extractTheme(spaceThemeKey);
        }
        if (theme == null) {
            theme = this.getGlobalTheme();
        }
        return theme;
    }

    public String getSpaceThemeKey(String spaceKey) {
        Map themeSettings = this.getThemeSettings(new ConfluenceBandanaContext(spaceKey));
        return (String)themeSettings.get(THEME_KEY);
    }

    private Map getThemeSettings(BandanaContext bandanaContext) {
        Map themeSettings = null;
        if (this.upgradeManager.isUpgraded()) {
            themeSettings = (Map)this.bandanaManager.getValue(bandanaContext, "atlassian.confluence.theme.settings", false);
        }
        if (themeSettings == null) {
            themeSettings = new HashMap();
        }
        return themeSettings;
    }

    public void setGlobalTheme(String themeCompleteKey) {
        Map themeSettings = this.getThemeSettings(new ConfluenceBandanaContext());
        String oldThemeKey = (String)themeSettings.get(THEME_KEY);
        themeSettings.put(THEME_KEY, themeCompleteKey);
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.theme.settings", (Object)themeSettings);
        this.eventManager.publishEvent((Event)new ThemeChangedEvent(this, null, oldThemeKey, themeCompleteKey));
    }

    public void setSpaceTheme(String spaceKey, String themeCompleteKey) {
        Map themeSettings = this.getThemeSettings(new ConfluenceBandanaContext(spaceKey));
        String oldThemeKey = (String)themeSettings.get(THEME_KEY);
        themeSettings.put(THEME_KEY, themeCompleteKey);
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), "atlassian.confluence.theme.settings", (Object)themeSettings);
        this.eventManager.publishEvent((Event)new ThemeChangedEvent(this, spaceKey, oldThemeKey, themeCompleteKey));
    }

    private Theme getTheme(String themeKey) {
        if (TextUtils.stringSet((String)themeKey)) {
            return this.extractTheme(themeKey);
        }
        return DefaultTheme.getInstance();
    }

    private Theme extractTheme(String themeModuleKey) {
        ModuleDescriptor moduleDesc = this.pluginAccessor.getEnabledPluginModule(themeModuleKey);
        if (moduleDesc == null) {
            log.warn((Object)("Unable to find configured theme module: " + themeModuleKey));
            return null;
        }
        Object theme = moduleDesc.getModule();
        if (!(theme instanceof Theme)) {
            log.warn((Object)("Found configured theme module: " + themeModuleKey + " but it was the wrong type: " + theme.getClass().getName()));
            return null;
        }
        return (Theme)theme;
    }

    public List getAvailableThemeDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(ThemeModuleDescriptor.class);
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setUpgradeManager(UpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }
}

