/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes.persistence.hibernate;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.core.PersistentDecorator;
import com.atlassian.confluence.themes.persistence.PersistentDecoratorDao;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class DefaultPersistentDecoratorDao
extends HibernateDaoSupport
implements PersistentDecoratorDao {
    private static final String CACHE_KEY_PERSISTENT_DECORATOR = DefaultPersistentDecoratorDao.class.getName();
    private CacheFactory cacheFactory;
    private Cache decoratorCache;

    public void saveOrUpdate(PersistentDecorator decorator) {
        if (this.get(decorator.getSpaceKey(), decorator.getName()) == null) {
            this.getHibernateTemplate().save((Object)decorator);
        } else {
            PersistentDecorator pd = this.getFromDB(decorator.getSpaceKey(), decorator.getName());
            pd.setBody(decorator.getBody());
        }
        this.getDecoratorCache().removeAll();
    }

    public PersistentDecorator get(String spaceKey, String name) {
        PersistentDecorator pd;
        DecoratorKey key = new DecoratorKey(spaceKey, name);
        DecoratorHolder holder = (DecoratorHolder)this.getDecoratorCache().get((Object)key);
        if (holder == null) {
            pd = this.getFromDB(spaceKey, name);
            holder = new DecoratorHolder(pd);
            this.getDecoratorCache().put((Object)key, (Object)holder);
        } else {
            pd = holder.getPersistentDecorator();
        }
        return pd;
    }

    public PersistentDecorator getFromDB(final String spaceKey, final String name) {
        return (PersistentDecorator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = null;
                if (TextUtils.stringSet((String)spaceKey)) {
                    query = session.getNamedQuery("confluence.persistentdecorator_findByNameAndSpaceKey");
                    query.setString("spaceKey", spaceKey);
                } else {
                    query = session.getNamedQuery("confluence.persistentdecorator_findGlobalDecoratorByName");
                }
                query.setCacheable(true);
                query.setString("name", name);
                return DataAccessUtils.singleResult((Collection)query.list());
            }
        });
    }

    public void remove(PersistentDecorator decorator) {
        if (this.get(decorator.getSpaceKey(), decorator.getName()) != null) {
            this.getHibernateTemplate().delete((Object)decorator);
        }
        this.getDecoratorCache().removeAll();
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public CacheFactory getCacheFactory() {
        if (this.cacheFactory == null) {
            this.cacheFactory = (CacheFactory)ContainerManager.getComponent((String)"cacheFactory");
        }
        return this.cacheFactory;
    }

    private Cache getDecoratorCache() {
        if (this.decoratorCache == null) {
            this.initCaches();
        }
        return this.decoratorCache;
    }

    private void initCaches() {
        if (this.getCacheFactory() != null) {
            this.decoratorCache = this.getCacheFactory().getCache(CACHE_KEY_PERSISTENT_DECORATOR);
        }
    }

    private static class DecoratorKey
    implements Serializable {
        private String spaceKey;
        private String name;

        public DecoratorKey(String spaceKey, String name) {
            this.spaceKey = spaceKey;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DecoratorKey that = (DecoratorKey)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return !(this.spaceKey != null ? !this.spaceKey.equals(that.spaceKey) : that.spaceKey != null);
        }

        public int hashCode() {
            int result = this.spaceKey != null ? this.spaceKey.hashCode() : 0;
            result = 29 * result + this.name.hashCode();
            return result;
        }
    }

    private static class DecoratorHolder
    implements Serializable {
        private PersistentDecorator persistentDecorator;

        public DecoratorHolder(PersistentDecorator pd) {
            this.persistentDecorator = pd;
        }

        public PersistentDecorator getPersistentDecorator() {
            return this.persistentDecorator;
        }
    }
}

