/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.themes.BaseColourScheme;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import org.apache.log4j.Category;

public class ColourSchemesUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(ColourSchemesUpgradeTask.class);

    public String getBuildNumber() {
        return "107";
    }

    public String getShortDescription() {
        return "Copies global and space colour scheme settings from confluence.cfg.xml over to new configuration files.";
    }

    public void doUpgrade() throws Exception {
        log.info((Object)"Beginning colour schemes upgrade");
        BootstrapManager setup = BootstrapUtils.getBootstrapManager();
        SpaceManager spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
        ColourSchemeManager colourSchemeManager = (ColourSchemeManager)ContainerManager.getComponent((String)"colourSchemeManager");
        BaseColourScheme globalColourScheme = new BaseColourScheme();
        for (String colourSchemeKey : ColourScheme.ORDERED_KEYS) {
            globalColourScheme.set(colourSchemeKey, setup.getString(colourSchemeKey));
            setup.removeProperty(colourSchemeKey);
        }
        colourSchemeManager.saveGlobalColourScheme(globalColourScheme);
        for (Space space : spaceManager.getAllSpaces()) {
            String prefix = this.convertSpaceKeyToPrefix(space.getKey());
            BaseColourScheme spaceColourScheme = new BaseColourScheme();
            for (String colourSchemeKey : ColourScheme.ORDERED_KEYS) {
                spaceColourScheme.set(colourSchemeKey, setup.getString(prefix + colourSchemeKey));
                setup.removeProperty(prefix + colourSchemeKey);
            }
            colourSchemeManager.saveSpaceColourScheme(space, spaceColourScheme);
        }
        setup.save();
        log.info((Object)"Completed colour schemes upgrade");
    }

    public Collection getErrors() {
        return null;
    }

    private String convertSpaceKeyToPrefix(String spaceKey) {
        String prefix = "";
        if (spaceKey != null && TextUtils.stringSet((String)spaceKey)) {
            prefix = spaceKey.toLowerCase() + ".";
        }
        return prefix;
    }
}

