/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.upgrade.DatabaseUpgradeTask;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class ConvertAdministerConfluenceToSystemAdministratorUpgradeTask
implements DatabaseUpgradeTask {
    private static Logger log = Logger.getLogger(ConvertAdministerConfluenceToSystemAdministratorUpgradeTask.class);
    private final SessionFactory sessionFactory;

    public ConvertAdministerConfluenceToSystemAdministratorUpgradeTask(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getBuildNumber() {
        return "1101";
    }

    public String getShortDescription() {
        return "Migrates all existing conluence administrators to the highest permission level (system administrator) as a new permission level(confluence administrator) is introduced.";
    }

    public void doUpgrade() throws Exception {
        JdbcTemplate template = new JdbcTemplate(this.getDataSource());
        int updates = template.update("UPDATE SPACEPERMISSIONS SET PERMTYPE='SYSTEMADMINISTRATOR' WHERE PERMTYPE='ADMINISTRATECONFLUENCE'");
        if (updates > 0) {
            log.info((Object)("Successfully updated " + updates + " admin permissions."));
        } else {
            log.info((Object)"No admin permissions found to update.");
        }
    }

    public Collection getErrors() {
        return Collections.EMPTY_LIST;
    }

    public void doNonDatabaseUpgrade() {
    }

    private DataSource getDataSource() {
        Connection conn;
        Session hibernateSession = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        try {
            conn = hibernateSession.connection();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        return new SingleConnectionDataSource(conn, true);
    }
}

