/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.util.Collection;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class CorrectAttachmentCreatorUpgradeTask
implements UpgradeTask {
    private SessionFactory sessionFactory;

    public String getBuildNumber() {
        return "1110";
    }

    public String getShortDescription() {
        return "Correct the creator of attachments.";
    }

    public void doUpgrade() throws Exception {
        JdbcTemplate template = new JdbcTemplate(this.getDataSource());
        template.execute("UPDATE ATTACHMENTS SET CREATOR = LASTMODIFIER where LASTMODIFIER IS NOT NULL");
        template.execute("UPDATE ATTACHMENTS SET CREATIONDATE = LASTMODDATE where LASTMODDATE IS NOT NULL");
    }

    public Collection getErrors() {
        return null;
    }

    private DataSource getDataSource() {
        Connection conn;
        Session hibernateSession = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        try {
            conn = hibernateSession.connection();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        return new SingleConnectionDataSource(conn, true);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

