/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.pages.Draft;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class DraftDataCleaningUpgradeTask
implements DatabaseUpgradeTask {
    private static final Logger log = Logger.getLogger(DraftDataCleaningUpgradeTask.class);
    private SessionFactory sessionFactory;

    public String getBuildNumber() {
        return "1412";
    }

    public String getShortDescription() {
        return "Clean up invalid Confluence draft data which prevents users accessing their drafts";
    }

    public void doUpgrade() throws Exception {
        List invalidDrafts;
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        try {
            invalidDrafts = session.find("from Draft d where d.pageId is null or d.pageId = '' or (d.draftType <> 'blogpost' and d.draftType <> 'page') or (d.pageVersion = 0 and d.pageId <> 0)");
        }
        catch (HibernateException e) {
            log.error((Object)"Could not clean up drafts due to retrieval error", (Throwable)e);
            return;
        }
        if (invalidDrafts.isEmpty()) {
            return;
        }
        int remaining = invalidDrafts.size();
        log.info((Object)("Cleaning up " + remaining + " invalid drafts."));
        for (Draft draft : invalidDrafts) {
            try {
                session.delete((Object)draft);
            }
            catch (HibernateException e) {
                log.info((Object)("Could not clean up invalid draft, " + draft + ": " + e.getMessage()));
            }
            if (--remaining % 1000 != 0) continue;
            log.info((Object)("Cleaning up drafts progress: " + remaining + " remaining"));
        }
        session.flush();
        log.info((Object)"Finished cleaning up invalid drafts.");
    }

    public void doNonDatabaseUpgrade() {
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Collection getErrors() {
        return Collections.emptyList();
    }
}

