/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.core.db.JDBCUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class DuplicateNotificationsCleanupUpgradeTask
implements UpgradeTask {
    private static Category LOG = Category.getInstance(DuplicateNotificationsCleanupUpgradeTask.class);
    private List errors = new LinkedList();

    public String getBuildNumber() {
        return "218";
    }

    public String getShortDescription() {
        return "A bug in 1.4.2 allowed duplicate notifications to be created. This task is designed to remove these duplicates.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        LOG.info((Object)"Duplicate notifications cleanup starting.");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        try {
            int i;
            Session hibernateSession = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            Connection connection = hibernateSession.connection();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            String query = "select count(*) as NOTIF_COUNT, PAGEID, SPACEID, USERNAME  from NOTIFICATIONS  group by USERNAME, PAGEID, SPACEID";
            String update = "update NOTIFICATIONS set USERNAME = lower(USERNAME)";
            LinkedList<Notification> duplicates = new LinkedList<Notification>();
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = connection.createStatement();
                stmt.executeUpdate(update);
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                    if (rs.getLong("NOTIF_COUNT") <= 1L) continue;
                    Notification notification = new Notification();
                    notification.pageid = rs.getLong("PAGEID");
                    if (rs.wasNull()) {
                        notification.pageid = -1L;
                    }
                    notification.spaceid = rs.getLong("SPACEID");
                    if (rs.wasNull()) {
                        notification.spaceid = -1L;
                    }
                    notification.user = rs.getString("USERNAME");
                    duplicates.add(notification);
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close((Statement)stmt);
                throw throwable;
            }
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((Statement)stmt);
            LinkedList<Long> duplicateNotifications = new LinkedList<Long>();
            PreparedStatement ps = null;
            try {
                for (i = 0; i < duplicates.size(); ++i) {
                    Notification notification = (Notification)duplicates.get(i);
                    String sqlSelectNotifications = "select NOTIFICATIONID from NOTIFICATIONS";
                    sqlSelectNotifications = notification.pageid != -1L ? sqlSelectNotifications + " where PAGEID = ? " : sqlSelectNotifications + " where PAGEID is NULL ";
                    sqlSelectNotifications = notification.spaceid != -1L ? sqlSelectNotifications + " and SPACEID = ? " : sqlSelectNotifications + " where SPACEID is NULL ";
                    sqlSelectNotifications = sqlSelectNotifications + " and USERNAME = ? ";
                    ps = connection.prepareStatement(sqlSelectNotifications);
                    int j = 1;
                    if (notification.pageid != -1L) {
                        ps.setLong(j, notification.pageid);
                        ++j;
                    }
                    if (notification.spaceid != -1L) {
                        ps.setLong(j, notification.spaceid);
                        ++j;
                    }
                    ps.setString(j, notification.user);
                    try {
                        rs = ps.executeQuery();
                        rs.next();
                        while (rs.next()) {
                            duplicateNotifications.add(new Long(rs.getLong(1)));
                        }
                        continue;
                    }
                    finally {
                        JDBCUtils.close((ResultSet)rs);
                    }
                }
            }
            finally {
                JDBCUtils.close(ps);
            }
            try {
                ps = connection.prepareStatement("delete from NOTIFICATIONS where NOTIFICATIONID = ? ");
                for (i = 0; i < duplicateNotifications.size(); ++i) {
                    ps.setLong(1, (Long)duplicateNotifications.get(i));
                    ps.executeUpdate();
                }
            }
            finally {
                JDBCUtils.close((Statement)ps);
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            LOG.info((Object)("Duplicate notifications cleanup complete. Removed " + duplicateNotifications.size() + " duplicates."));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.info((Object)"Duplicate notifications cleanup failed.");
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    private class Notification {
        private long pageid;
        private long spaceid;
        private String user;

        private Notification() {
        }
    }
}

