/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class ExcerptMacroUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(ExcerptMacroUpgradeTask.class);

    public String getBuildNumber() {
        return "206";
    }

    public String getShortDescription() {
        return "Creates a new TEXT_VAL column to store properties longer than 255 char.";
    }

    public void doUpgrade() throws Exception {
        log.info((Object)"Starting upgrade. Copy content from STRING_VAL to TEXT_VAL column.");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        this.updateContentTable(session);
        log.info((Object)"Upgrade task complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContentTable(Session session) throws HibernateException, SQLException {
        Statement statement;
        block4: {
            statement = null;
            try {
                Connection connection = session.connection();
                statement = connection.createStatement();
                statement.execute("update OS_PROPERTYENTRY set TEXT_VAL = STRING_VAL where KEY_TYPE = 6");
                if (connection.getAutoCommit()) break block4;
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.closeStatementQuietly(statement);
                    throw throwable;
                }
                SQLUtils.closeStatementQuietly(statement);
            }
        }
        SQLUtils.closeStatementQuietly(statement);
    }

    public Collection getErrors() {
        return null;
    }
}

