/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Category;

public class GuardPermissionsUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(UpgradeTask.class);
    private List errors = new ArrayList();

    public String getBuildNumber() {
        return "58";
    }

    public String getShortDescription() {
        return "Make global and space permissions consistent with new 'guard permissions' scheme";
    }

    public void doUpgrade() throws Exception {
        try {
            log.info((Object)"Starting to upgrade permissions from 1.1 -> 1.2");
            SpacePermissionManager permissionManager = (SpacePermissionManager)ContainerManager.getComponent((String)"spacePermissionManager");
            permissionManager.fixPermissions();
            log.info((Object)"Finished upgrading permissions");
        }
        catch (Exception e) {
            log.error((Object)"Upgrade task could not fix permissions: permissions may need manual checking", (Throwable)e);
            this.errors.add("Upgrade task could not fix permissions: permissions may need manual checking: " + e.getMessage());
        }
    }

    public Collection getErrors() {
        return this.errors;
    }
}

