/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.event.events.admin.ResetHibernateIdRangeEvent;
import com.atlassian.confluence.security.persistence.dao.hibernate.legacy.HibernateKey;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.hibernate.ResettableTableHiLoGenerator;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import com.atlassian.upgrade.UpgradeException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.EntityPersister;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HiLoIdRepairUpgradeTask
implements DatabaseUpgradeTask {
    private static Category log = Category.getInstance(HiLoIdRepairUpgradeTask.class);
    private static final String HIBERNATE_UNIQUE_KEY_TABLE = "hibernate_unique_key";
    private static final String HIBERNATE_UNIQUE_KEY_COLUMN = "next_hi";
    private List errors = new ArrayList();
    private static final long MAX_VALUE_TO_AVOID_TRUNCATION = 70366596661249L;
    private final EventManager eventManager;

    public HiLoIdRepairUpgradeTask(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public String getBuildNumber() {
        return "601";
    }

    public String getShortDescription() {
        return "Set the hibernat_unique_key.next_hi value to the high bits of the highest id in the DB, +1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Beginning upgrade: HiLoIdRepairUpgradeTask");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Statement statement = null;
        Connection connection = null;
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            connection = session.connection();
            statement = connection.createStatement();
            Map metaDataMap = sessionFactory.getAllClassMetadata();
            long maximumId = 0L;
            int maxLo = 0;
            for (Map.Entry entry : metaDataMap.entrySet()) {
                long value;
                String sql;
                ResultSet rs;
                Class c = (Class)entry.getKey();
                if (c == HibernateKey.class) continue;
                ClassMetadata metadata = (ClassMetadata)entry.getValue();
                ClassPersister persister = ((SessionFactoryImplementor)sessionFactory).getPersister(c);
                if (!(persister instanceof EntityPersister) || !(persister.getIdentifierGenerator() instanceof ResettableTableHiLoGenerator)) continue;
                EntityPersister entityPersister = (EntityPersister)persister;
                ResettableTableHiLoGenerator generator = (ResettableTableHiLoGenerator)persister.getIdentifierGenerator();
                if (maxLo == 0) {
                    maxLo = generator.getMaxLo();
                } else if (maxLo != generator.getMaxLo()) {
                    throw new UpgradeException("One generator uses " + maxLo + " for maxLo, generator for " + c.getName() + " uses " + generator.getMaxLo());
                }
                String[] idColumnNames = entityPersister.getIdentifierColumnNames();
                if (idColumnNames.length != 1) {
                    this.errors.add("expected a single id column for " + c + " found " + idColumnNames.length);
                }
                if (!(rs = statement.executeQuery(sql = "select max(" + idColumnNames[0] + ") from " + entityPersister.getTableName() + " where " + idColumnNames[0] + " < " + 70366596661249L)).next()) {
                    this.errors.add("no maximum id returned for " + c);
                }
                if ((value = rs.getLong(1)) > maximumId) {
                    maximumId = value;
                }
                rs.close();
            }
            int nextHi = (int)(maximumId / (long)(maxLo + 1)) + 1;
            log.info((Object)("Setting new next_hi to " + nextHi));
            if (statement.executeUpdate("update hibernate_unique_key set next_hi = " + nextHi) == 0 && statement.executeUpdate("insert into hibernate_unique_key values(" + nextHi + ")") == 0) {
                this.errors.add("failed to insert initial next_hi value");
            }
            this.eventManager.publishEvent((Event)new ResetHibernateIdRangeEvent(this));
        }
        catch (Exception e) {
            log.error((Object)"Error finding maximum next_hi value", (Throwable)e);
            this.errors.add(e.getMessage());
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.commit();
            }
            if (!this.errors.isEmpty()) {
                throw new UpgradeException("Errors occurred.");
            }
            log.info((Object)"Completed database update: HiLoIdRepairUpgradeTask");
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void doNonDatabaseUpgrade() {
    }
}

