/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.upgrade.UpgradeTask;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Category;

public class IncreasePoolSizeUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(IncreasePoolSizeUpgradeTask.class);
    private static final String MAX_SIZE_KEY = "hibernate.c3p0.max_size";
    private static final int NEW_MAX_POOL_SIZE = 15;

    public String getBuildNumber() {
        return "213";
    }

    public String getShortDescription() {
        return "Increase the size of the DB connection pool.";
    }

    public void doUpgrade() throws Exception {
        log.info((Object)"Beginning DB connection pool size upgrade");
        BootstrapManager setup = BootstrapUtils.getBootstrapManager();
        String currentSizeString = (String)setup.getProperty(MAX_SIZE_KEY);
        if (currentSizeString == null) {
            log.info((Object)"No connection pool size set. Ignoring.");
            return;
        }
        int currentSize = 0;
        try {
            currentSize = Integer.parseInt(currentSizeString);
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("Couldn't parse pool size of '" + currentSizeString + "', assuming zero."));
            currentSize = 0;
        }
        if (currentSize < 15) {
            setup.setProperty(MAX_SIZE_KEY, Integer.toString(15));
            setup.save();
            log.info((Object)"increased pool size to 15");
        } else {
            log.info((Object)("kept ppol size at " + currentSize));
        }
        log.info((Object)"Completed DB connection pool size upgrade");
    }

    public Collection getErrors() {
        return Collections.EMPTY_LIST;
    }
}

