/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.plugin.PluginController;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Category;

public class MacroToPluginUpgradeTask
implements UpgradeTask {
    private static final Category log = Category.getInstance(MacroToPluginUpgradeTask.class);

    public String getBuildNumber() {
        return "102";
    }

    public String getShortDescription() {
        return "Upgrade confluence configuration to use plugin config keys for macros";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Starting macro -> plugin config upgrade task");
        BootstrapManager setup = BootstrapUtils.getBootstrapManager();
        try {
            this.fixAllProperties(setup);
        }
        finally {
            setup.save();
        }
        log.info((Object)"Completed macro -> plugin config upgrade task");
    }

    private void fixAllProperties(BootstrapManager setup) {
        PluginController pluginManager = (PluginController)ContainerManager.getComponent((String)"pluginController");
        if (setup.isSetupComplete()) {
            Map props = setup.getPropertiesWithPrefix("confluence.macro.state.global.");
            for (Map.Entry entry : props.entrySet()) {
                this.fix(pluginManager, (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void fix(PluginController pluginManager, String key, String value) {
        String macroCompleteKey = key.substring("confluence.macro.state.global.".length());
        if (macroCompleteKey.startsWith("confluence")) {
            macroCompleteKey = macroCompleteKey.replaceFirst("confluence", "confluence.macros");
        }
        BootstrapUtils.getBootstrapManager().setProperty(key, null);
        log.debug((Object)("Setting state of " + macroCompleteKey + " to " + value));
        if ("true".equals(value)) {
            this.enable(pluginManager, macroCompleteKey);
        } else {
            this.disable(pluginManager, macroCompleteKey);
        }
    }

    private void enable(PluginController pluginManager, String key) {
        if (key.indexOf(":") < 0) {
            pluginManager.enablePlugin(key);
        } else {
            pluginManager.enablePluginModule(key);
        }
    }

    private void disable(PluginController pluginManager, String key) {
        if (key.indexOf(":") < 0) {
            pluginManager.disablePlugin(key);
        } else {
            pluginManager.disablePluginModule(key);
        }
    }

    public Collection getErrors() {
        return null;
    }
}

