/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.mail.MailContentManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.upgrade.UpgradeException;
import com.atlassian.upgrade.UpgradeTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class MailCreationDateUpgradeTask
implements UpgradeTask {
    private SpaceManager spaceManager;
    private MailContentManager mailManager;
    private SessionFactory sessionFactory;
    private List errors = new LinkedList();

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setMailContentManager(MailContentManager mailManager) {
        this.mailManager = mailManager;
    }

    public void setSessionFactory(SessionFactory factory) {
        this.sessionFactory = factory;
    }

    public String getBuildNumber() {
        return "211";
    }

    public String getShortDescription() {
        return "Updates the creation date of mail content objects to be the received/sent date from the email as opposed to the date the email was imported into confluence.";
    }

    public void doUpgrade() throws UpgradeException {
        List spaces = this.spaceManager.getAllSpaces();
        Iterator spaceIterator = spaces.iterator();
        LinkedList<Mail> loadedMailObjects = new LinkedList<Mail>();
        try {
            while (spaceIterator.hasNext()) {
                Space space = (Space)spaceIterator.next();
                Iterator mailIterator = this.mailManager.getSpaceMailIterator(space.getKey());
                while (mailIterator.hasNext()) {
                    Mail mail = (Mail)mailIterator.next();
                    loadedMailObjects.add(mail);
                    try {
                        MimeMessage rawEmail = mail.getMimeMessage();
                        if (rawEmail.getReceivedDate() != null) {
                            mail.setCreationDate(rawEmail.getSentDate());
                        } else if (rawEmail.getSentDate() != null) {
                            mail.setCreationDate(rawEmail.getSentDate());
                        }
                    }
                    catch (MessagingException e) {
                        this.errors.add("MailCreationDateUpgradeTask: Failed to upgrade message(" + mail.getMessageId() + ") " + "cause: " + ((Object)((Object)e)).getClass().getName() + " message: " + e.getMessage());
                    }
                    this.periodicFlush(loadedMailObjects);
                }
                this.flush(loadedMailObjects);
            }
        }
        catch (HibernateException e) {
            this.errors.add("MailCreationDateUpgradeTask: " + ((Object)((Object)e)).getClass().getName() + " message: " + e.getMessage());
            throw new UpgradeException((Throwable)e);
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    private void periodicFlush(List objectsToEvict) throws HibernateException {
        if (objectsToEvict.size() < 100) {
            return;
        }
        this.flush(objectsToEvict);
    }

    private void flush(List objectsToEvict) throws HibernateException {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        session.flush();
        Iterator it = objectsToEvict.iterator();
        while (it.hasNext()) {
            session.evict(it.next());
        }
        objectsToEvict.clear();
    }
}

