/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class MailDatabaseUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(MailDatabaseUpgradeTask.class);

    public String getBuildNumber() {
        return "104";
    }

    public String getShortDescription() {
        return "Updates the database to store mail";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Beginning database update: mail");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session session = null;
        try {
            if (!((String)BootstrapUtils.getBootstrapManager().getProperty("hibernate.dialect")).endsWith("PostgreSQLDialect")) {
                return;
            }
            session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            this.updateSchema(session);
        }
        finally {
            log.info((Object)"Completed database update: mail");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(Session session) throws HibernateException, SQLException {
        Statement statement = null;
        try {
            Connection connection = session.connection();
            statement = connection.createStatement();
            statement.execute("alter table CONTENT add column MAILSPACEID bigint");
            statement.execute("alter table CONTENT add column MESSAGEID VARCHAR(255)");
            statement.execute("alter table CONTENT add constraint FK6382C059A0A8D6EA foreign key (MAILSPACEID) references SPACES");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.closeStatementQuietly(statement);
            throw throwable;
        }
        SQLUtils.closeStatementQuietly(statement);
    }

    public Collection getErrors() {
        return null;
    }
}

