/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.upgrade.UpgradeTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Collection;

public class MailServerConfigUpdate
implements UpgradeTask {
    public String getBuildNumber() {
        return "54";
    }

    public String getShortDescription() {
        return "Updates the change in the mail config file from \"<from>\" to \"<defaultFrom>\"";
    }

    public void doUpgrade() throws Exception {
        File file = new File(BootstrapUtils.getBootstrapManager().getConfluenceHome(), "confluence-mail.cfg.xml");
        if (file.exists()) {
            String config = this.readConfig(file);
            config = config.replaceAll("<from>", "<defaultFrom>");
            config = config.replaceAll("</from>", "</defaultFrom>");
            this.writeConfig(file, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfig(File file, String config) throws IOException {
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            out.write(config);
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readConfig(File file) throws IOException {
        String string;
        BufferedReader reader = null;
        StringWriter writer = null;
        try {
            String line;
            writer = new StringWriter();
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                writer.write(line + "\n");
            }
            writer.flush();
            string = writer.toString();
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            IOUtils.close(writer);
            throw throwable;
        }
        IOUtils.close(reader);
        IOUtils.close(writer);
        return string;
    }

    public Collection getErrors() {
        return null;
    }
}

