/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Properties;

public class MoveFormatsToDatabaseUpgradeTask
implements DatabaseUpgradeTask {
    private static final String DEFAULT_FORMATTING_PROPERTIES_FILE_NAME = "default-formatting.properties";
    private BootstrapManager bootstrapManager;
    private FormatSettingsManager formatSettingsManager;

    public String getBuildNumber() {
        return "635";
    }

    public String getShortDescription() {
        return "Moves the date and number formats to the database";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        String decimalNumberFormat;
        String longNumberFormat;
        String dateTimeFormat;
        String timeFormat;
        File file = this.getFormatPropertiesFile();
        if (!file.exists() || !file.isFile()) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            properties.load(fis);
        }
        catch (Throwable throwable) {
            IOUtils.close(fis);
            throw throwable;
        }
        IOUtils.close(fis);
        String dateFormat = properties.getProperty("date.format");
        if (dateFormat != null) {
            this.formatSettingsManager.setDateFormat(dateFormat);
        }
        if ((timeFormat = properties.getProperty("time.format")) != null) {
            this.formatSettingsManager.setTimeFormat(timeFormat);
        }
        if ((dateTimeFormat = properties.getProperty("datetime.format")) != null) {
            this.formatSettingsManager.setDateTimeFormat(dateTimeFormat);
        }
        if ((longNumberFormat = properties.getProperty("long.number.format")) != null) {
            this.formatSettingsManager.setLongNumberFormat(longNumberFormat);
        }
        if ((decimalNumberFormat = properties.getProperty("decimal.number.format")) != null) {
            this.formatSettingsManager.setDecimalNumberFormat(decimalNumberFormat);
        }
        this.doNonDatabaseUpgrade();
    }

    public void doNonDatabaseUpgrade() {
        File file = this.getFormatPropertiesFile();
        if (!file.exists() || !file.isFile()) {
            return;
        }
        file.delete();
    }

    private File getFormatPropertiesFile() {
        return new File(this.bootstrapManager.getConfluenceHome(), DEFAULT_FORMATTING_PROPERTIES_FILE_NAME);
    }

    public Collection getErrors() {
        return null;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }
}

