/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.core.PersistentDecorator;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.persistence.PersistentDecoratorDao;
import com.atlassian.confluence.util.TemplateSupport;
import com.atlassian.upgrade.UpgradeTask;
import com.opensymphony.util.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Category;

public class MoveLayoutsToDatabaseUpgradeTask
implements UpgradeTask {
    public static final Category log = Category.getInstance(MoveLayoutsToDatabaseUpgradeTask.class);
    public static final String DECORATORS = "decorators";
    private PersistentDecoratorDao persistentDecoratorDao;
    public static final String SPACE_EXPORT_LAYOUT = TemplateSupport.classToTemplatePath(Space.class) + ".htmlexport.vm";
    public static final String PAGE_EXPORT_LAYOUT = TemplateSupport.classToTemplatePath(Page.class) + ".htmlexport.vm";

    public String getBuildNumber() {
        return "605";
    }

    public String getShortDescription() {
        return "Moves the layouts to the database for clustering";
    }

    public void doUpgrade() throws Exception {
        log.info((Object)"Begin: Moves the layouts to the database");
        File velocityDir = new File(BootstrapUtils.getBootstrapManager().getConfluenceHome(), "velocity");
        if (velocityDir.exists()) {
            File[] spaceDecoratorDirs = velocityDir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            for (int i = 0; i < spaceDecoratorDirs.length; ++i) {
                File spaceDecoratorsDir = spaceDecoratorDirs[i];
                this.migrateLayouts(spaceDecoratorsDir, spaceDecoratorsDir.getName());
            }
            this.migrateLayouts(velocityDir, null);
        }
        com.atlassian.core.util.FileUtils.deleteDir((File)velocityDir);
        log.info((Object)"Complete");
    }

    private void migrateLayouts(File baseDir, String spaceKey) {
        File decoratorsDir = new File(baseDir, DECORATORS);
        if (decoratorsDir.exists()) {
            File[] decoratorFiles = decoratorsDir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".vmd");
                }
            });
            for (int j = 0; j < decoratorFiles.length; ++j) {
                File decoratorFile = decoratorFiles[j];
                String decoratorName = "decorators/" + decoratorFile.getName();
                String content = FileUtils.readFile((File)decoratorFile);
                PersistentDecorator decorator = new PersistentDecorator(spaceKey, decoratorName, content, new Date());
                this.persistentDecoratorDao.saveOrUpdate(decorator);
            }
        }
        if (new File(baseDir, "com").exists()) {
            File pageExportLayout;
            File spaceExportLayout = new File(baseDir, SPACE_EXPORT_LAYOUT);
            if (spaceExportLayout.exists()) {
                String content = FileUtils.readFile((File)spaceExportLayout);
                PersistentDecorator decorator = new PersistentDecorator(spaceKey, SPACE_EXPORT_LAYOUT, content, new Date());
                this.persistentDecoratorDao.saveOrUpdate(decorator);
            }
            if ((pageExportLayout = new File(baseDir, PAGE_EXPORT_LAYOUT)).exists()) {
                String content = FileUtils.readFile((File)pageExportLayout);
                PersistentDecorator decorator = new PersistentDecorator(spaceKey, PAGE_EXPORT_LAYOUT, content, new Date());
                this.persistentDecoratorDao.saveOrUpdate(decorator);
            }
        }
    }

    public Collection getErrors() {
        return null;
    }

    public void setPersistentDecoratorDao(PersistentDecoratorDao persistentDecoratorDao) {
        this.persistentDecoratorDao = persistentDecoratorDao;
    }
}

