/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.user.UserConfigurationChecker;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import com.atlassian.user.EntityException;
import com.atlassian.user.configuration.DelegationAccessor;
import com.atlassian.user.util.migration.EntityMigrator;
import com.atlassian.user.util.migration.Log4jMigrationProgressListener;
import com.atlassian.user.util.migration.MigrationProgressListener;
import com.atlassian.user.util.migration.MigratorConfiguration;
import edu.emory.mathcs.backport.java.util.LinkedList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class OSUserToAtlassianUserMigrationUpgradeTask
implements DatabaseUpgradeTask {
    static final transient Logger log = Logger.getLogger(OSUserToAtlassianUserMigrationUpgradeTask.class);
    private final EntityMigrator entityMigrator;
    private final Collection errors = new LinkedList();
    private JohnsonEventContainer johnsonEventContainer;
    private final DelegationAccessor delegationAccessor;

    public OSUserToAtlassianUserMigrationUpgradeTask(EntityMigrator entityMigrator, DelegationAccessor delegationAccessor) {
        if (entityMigrator == null) {
            throw new IllegalArgumentException("Entity migrator must NOT be null!");
        }
        this.delegationAccessor = delegationAccessor;
        this.entityMigrator = entityMigrator;
    }

    public final String getBuildNumber() {
        return "1012";
    }

    public final String getShortDescription() {
        return "Migrating from OS User management to Atlassian User management";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doUpgrade() throws Exception {
        if (UserConfigurationChecker.isStandardOsUser() && UserConfigurationChecker.isStandardAtlassianUser(this.delegationAccessor)) {
            log.info((Object)"Detected standard user configuration, migrating user management.");
            Event userMigrationEvent = new Event(JohnsonConfig.getInstance().getEventType("upgrade"), "User migration in progress", JohnsonConfig.getInstance().getEventLevel("warning"));
            this.johnsonEventContainer.addEvent(userMigrationEvent);
            try {
                MigratorConfiguration migratorConfiguration = new MigratorConfiguration();
                migratorConfiguration.setMigrateMembershipsForExistingUsers(true);
                this.entityMigrator.migrate(migratorConfiguration, (MigrationProgressListener)new Log4jMigrationProgressListener(log));
            }
            catch (EntityException e) {
                this.errors.add("An error occured migrating users from OS User management to Atlassian User management: " + e.getMessage());
                log.error((Object)("An error occured migrating users from OS User management to Atlassian User management: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.johnsonEventContainer.removeEvent(userMigrationEvent);
            }
        } else {
            log.info((Object)"Detected non-standard user configuration, not migrating user management.");
        }
    }

    public void doNonDatabaseUpgrade() {
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setJohnsonEventContainer(JohnsonEventContainer johnsonEventContainer) {
        this.johnsonEventContainer = johnsonEventContainer;
    }
}

