/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.util.AncestorTableBuilder;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class PagePermissionUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(PagePermissionUpgradeTask.class);
    private CacheFactory cacheFactory;

    public String getBuildNumber() {
        return "201";
    }

    public String getShortDescription() {
        return "Updates old permission types. Builds CONFANCESTORS table that maintains page hierarchy information.";
    }

    public void doUpgrade() throws Exception {
        this.updateDatabase();
    }

    private void updateDatabase() throws HibernateException, SQLException {
        log.info((Object)"Beginning database update: ContentPermissions");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        this.updateDatabase(sessionFactory);
        this.updateContentPermissionType(sessionFactory);
        log.info((Object)"Populating ancestor table ...");
        AncestorTableBuilder builder = new AncestorTableBuilder();
        builder.build(sessionFactory);
        log.info((Object)"Populating ancestor table complete.");
        log.info((Object)"Completed database update: ContentPermissions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void updateContentPermissionType(SessionFactory sessionFactory) throws HibernateException {
        Statement statement = null;
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            Connection connection = session.connection();
            statement = connection.createStatement();
            statement.execute("update CONTENTLOCK set TITLE = 'Edit'");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            this.cacheFactory.getCache(ContentPermission.class.getName()).removeAll();
        }
        catch (SQLException e) {
            log.error((Object)("Error whilst updating the content permission types: " + e.getMessage()), (Throwable)e);
            JDBCUtils.close((Statement)statement);
        }
        catch (Exception e2) {
            log.error((Object)("Error whilst updating the content permission types: " + e2.getMessage()), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    JDBCUtils.close(statement);
                    throw throwable;
                }
            }
            JDBCUtils.close((Statement)statement);
        }
        JDBCUtils.close((Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDatabase(SessionFactory sessionFactory) throws HibernateException, SQLException {
        Statement statement = null;
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            Connection connection = session.connection();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            statement = connection.createStatement();
            statement.execute("delete from CONTENTLOCK where CREATOR IS NULL OR CONTENT IS NULL");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(statement);
            throw throwable;
        }
        JDBCUtils.close((Statement)statement);
    }

    public Collection getErrors() {
        return null;
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }
}

