/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.upgrade.PersonalInformationRepairTask;
import com.atlassian.confluence.user.UserConfigurationChecker;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.DelegationAccessor;
import java.util.Collection;
import java.util.Collections;
import org.dom4j.DocumentException;
import uk.ltd.getahead.dwr.util.Logger;

public class PersonalInformationRepairUpgradeTask
implements DatabaseUpgradeTask {
    private static Logger logger = Logger.getLogger(PersonalInformationRepairUpgradeTask.class);
    private DelegationAccessor delegationAccessor;
    private PersonalInformationRepairTask runnable;

    public PersonalInformationRepairUpgradeTask(PersonalInformationRepairTask task) {
        this.runnable = task;
    }

    public void doNonDatabaseUpgrade() {
    }

    public void doUpgrade() throws Exception {
        boolean standardUserConfiguration = false;
        try {
            standardUserConfiguration = UserConfigurationChecker.isStandardOsUser() && UserConfigurationChecker.isStandardAtlassianUser(this.delegationAccessor);
        }
        catch (ConfigurationException ex) {
            logger.warn("Could not parse Atlassian User configuration so no PersonalInformation repair performed.", (Throwable)ex);
        }
        catch (DocumentException ex) {
            logger.warn("Could not parse OS User configuration so no PersonalInformation repair performed.", (Throwable)ex);
        }
        if (standardUserConfiguration) {
            logger.info("Standard user configuration detected so no PersonalInformation repair task necessary.");
            return;
        }
        new Thread((Runnable)this.runnable, "PersonalInformationRepair").start();
    }

    public String getBuildNumber() {
        return "1416";
    }

    public Collection getErrors() {
        return Collections.emptyList();
    }

    public String getShortDescription() {
        return "Create PersonalInformation objects for any content creators that do not have one.";
    }

    public void setDelegationAccessor(DelegationAccessor delegationAccessor) {
        this.delegationAccessor = delegationAccessor;
    }
}

