/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.upgrade.UpgradeTask;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.search.page.Pager;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class RemoveActiveFlagUpgradeTask
implements UpgradeTask {
    private static final Logger log = Logger.getLogger(RemoveActiveFlagUpgradeTask.class);
    private UserAccessor userAccessor;
    private PropertySetFactory propertySetFactory;
    private SpacePermissionManager spacePermissionManager;
    public SpacePermission USE_CONF_PERM = new SpacePermission("USECONFLUENCE", null, null);
    private ArrayList errors = new ArrayList();

    public String getBuildNumber() {
        return "402";
    }

    public String getShortDescription() {
        return "Removes the deactivated flag from property sets";
    }

    public void doUpgrade() throws Exception {
        Set deactivatedUsers = this.getDeactivatedUsers();
        Iterator deactivatedUsersIter = deactivatedUsers.iterator();
        while (deactivatedUsersIter.hasNext()) {
            User user = this.userAccessor.getUser((String)deactivatedUsersIter.next());
            if (!this.spacePermissionManager.hasPermission("USECONFLUENCE", null, user)) continue;
            this.spacePermissionManager.removePermission(this.USE_CONF_PERM);
            Pager usersGroup = this.userAccessor.getGroups(user);
            for (Group group : usersGroup) {
                if (!this.spacePermissionManager.groupHasPermission("USECONFLUENCE", null, group.getName())) continue;
                PropertySet ps = this.propertySetFactory.getPropertySet((Entity)user);
                try {
                    this.userAccessor.removeMembership(group, user);
                }
                catch (Exception e) {
                    log.info((Object)("Could not remove membership for user [" + user.getName() + "] in group [" + group.getName() + "]"));
                    this.errors.add("Could not remove membership for user [" + user.getName() + "] in group [" + group.getName() + "]");
                    continue;
                }
                ps.remove("confluence.user.deactivated");
            }
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    private synchronized Set getDeactivatedUsers() {
        log.info((Object)"Populating deactivated user cache. Some actions may not respond during this time.");
        HashSet<String> deactivatedUsers = new HashSet<String>();
        for (User user : this.userAccessor.getUsers()) {
            UserPreferences prefs = null;
            try {
                prefs = new UserPreferences(this.propertySetFactory.getPropertySet((Entity)user));
            }
            catch (EntityException e) {
                log.error((Object)("Unable to populate user cache, cause : " + e.getMessage()), (Throwable)e);
            }
            if (!prefs.getBoolean("confluence.user.deactivated")) continue;
            deactivatedUsers.add(user.getName());
        }
        log.info((Object)"Done populating deactivated user cache");
        return deactivatedUsers;
    }

    public PropertySetFactory getPropertySetFactory() {
        return this.propertySetFactory;
    }

    public void setPropertySetFactory(PropertySetFactory propertySetFactory) {
        this.propertySetFactory = propertySetFactory;
    }

    public SpacePermissionManager getSpacePermissionManager() {
        return this.spacePermissionManager;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }
}

