/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class RemoveBlankReferrersUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(RemoveBlankReferrersUpgradeTask.class);

    public String getBuildNumber() {
        return "120";
    }

    public String getShortDescription() {
        return "Removes all referrers that have been blanked by the referral link bug introduced in 1.3.3";
    }

    public void doUpgrade() throws Exception {
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        log.warn((Object)"Removing blank referrers ...");
        this.updateExternalLinksTable(session);
        log.warn((Object)"Removing blank referrers complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExternalLinksTable(Session session) throws HibernateException, SQLException {
        Statement statement = null;
        try {
            Connection connection = session.connection();
            statement = connection.createStatement();
            statement.execute("delete from EXTRNLNKS where URL = ''");
            statement.execute("delete from TRACKBACKLINKS where URL = ''");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.closeStatementQuietly(statement);
            throw throwable;
        }
        SQLUtils.closeStatementQuietly(statement);
    }

    public Collection getErrors() {
        return null;
    }
}

