/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.util.AncestorTableBuilder;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class RenamePositionColumnUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(RenamePositionColumnUpgradeTask.class);

    public String getBuildNumber() {
        return "313";
    }

    public String getShortDescription() {
        return "Rename the ancestors.position column.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Beginning database update: RenamePositionColumnUpgradeTask");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            this.updateSchema(session);
        }
        finally {
            log.info((Object)"Completed database update: RenamePositionColumnUpgradeTask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(Session session) throws HibernateException, SQLException {
        Statement statement = null;
        try {
            Connection connection = session.connection();
            statement = connection.createStatement();
            log.info((Object)"Dropping old ANCESTORS table.");
            this.doOperationIgnoringErrors(statement, "delete from ANCESTORS");
            this.doOperationIgnoringErrors(statement, "drop table ANCESTORS");
            SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
            log.info((Object)"Re-populating new ancestor table ...");
            AncestorTableBuilder builder = new AncestorTableBuilder();
            builder.build(sessionFactory);
            log.info((Object)"Re-populating new ancestor table complete.");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(statement);
            throw throwable;
        }
        JDBCUtils.close((Statement)statement);
    }

    private void doOperationIgnoringErrors(Statement statement, String operation) {
        try {
            statement.execute(operation);
        }
        catch (Exception e) {
            log.error((Object)"RenamePositionColumnUpgradeTask failed.", (Throwable)e);
        }
    }

    public Collection getErrors() {
        return null;
    }
}

