/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.upgrade.UpgradeUtils;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.util.ProfilePicture;
import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.upgrade.UpgradeTask;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.apache.log4j.Category;

public class ResizeProfileImagesUpgradeTask
implements UpgradeTask {
    public static final Category log = Category.getInstance(ResizeProfileImagesUpgradeTask.class);
    private PersonalInformationManager personalInformationManager;
    private AttachmentManager attachmentManager;

    public String getBuildNumber() {
        return "502";
    }

    public String getShortDescription() {
        return "Resizes all existing profile images to 48 X 48 pixels.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Starting ...");
        Session session = UpgradeUtils.getSession();
        Statement statement = null;
        Connection connection = null;
        try {
            connection = session.connection();
            statement = connection.createStatement();
            ResultSet rs = statement.executeQuery("select OS_USER.USERNAME, OS_PROPERTYENTRY.STRING_VAL from OS_USER, OS_PROPERTYENTRY where OS_USER.ID = OS_PROPERTYENTRY.ENTITY_ID and OS_PROPERTYENTRY.ENTITY_KEY = 'confluence.user.profile.picture'");
            ArrayList<Attachment> profilePictures = new ArrayList<Attachment>();
            while (rs.next()) {
                Attachment profilePicture;
                String username = rs.getString(1);
                String profileFilename = rs.getString(2);
                PersonalInformation personalInfo = this.personalInformationManager.getPersonalInformation(username);
                if (personalInfo == null || (profilePicture = this.attachmentManager.getAttachment(personalInfo, profileFilename)) == null) continue;
                profilePictures.add(profilePicture);
            }
            Iterator iterator = profilePictures.iterator();
            while (iterator.hasNext()) {
                this.resizeProfilePicture((Attachment)iterator.next());
            }
        }
        catch (HibernateException e) {
            log.error((Object)"Hibernate error occured whilst performing ResizeProfileImagesUpgradeTask", (Throwable)e);
            SQLUtils.closeStatementQuietly(statement);
        }
        catch (SQLException e2) {
            log.error((Object)"SQL error occured whilst performing ResizeProfileImagesUpgradeTask", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    SQLUtils.closeStatementQuietly(statement);
                    throw throwable;
                }
            }
            SQLUtils.closeStatementQuietly(statement);
        }
        SQLUtils.closeStatementQuietly(statement);
        log.info((Object)"Complete.");
    }

    private void resizeProfilePicture(Attachment attachment) {
        try {
            File resizedProfileImage = new ProfilePicture(this.attachmentManager.getAttachmentData(attachment), attachment.getFileName()).create();
            Attachment previousVersion = (Attachment)attachment.clone();
            attachment.setFileSize(resizedProfileImage.length());
            this.attachmentManager.saveAttachment(attachment, previousVersion, new FileInputStream(resizedProfileImage));
        }
        catch (Throwable e) {
            log.error((Object)("Error resizing " + attachment.getFileName() + " with attachment id: " + attachment.getId() + " attached to content: " + attachment.getContent()), e);
        }
    }

    public Collection getErrors() {
        return null;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

