/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.Resource;
import com.atlassian.confluence.util.ResourceManager;
import com.atlassian.upgrade.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class ResourceUpgradeTask
implements UpgradeTask {
    private static final Category log = Category.getInstance(ResourceUpgradeTask.class);
    BootstrapManager bootstrapManager;
    ResourceManager resourceManager;
    SpaceManager spaceManager;
    BandanaManager bandanaManager;
    ArrayList errors = new ArrayList();

    public String getBuildNumber() {
        return "207";
    }

    public String getShortDescription() {
        return "Upgrade Confluence resources to store any file objects as Strings representing paths relative to confluence home.";
    }

    public void doUpgrade() throws Exception {
        this.upgradeGlobalResources();
        this.upgradeSpaceResources();
    }

    private void upgradeSpaceResources() {
        Iterator spaceIterator = this.spaceManager.getAllSpaces().iterator();
        while (spaceIterator.hasNext()) {
            String spaceKey = ((Space)spaceIterator.next()).getKey();
            ConfluenceBandanaContext ctx = new ConfluenceBandanaContext(spaceKey);
            List spaceResources = (List)this.bandanaManager.getValue((BandanaContext)ctx, "atlassian.confluence.user.resources", false);
            if (spaceResources == null || spaceResources.isEmpty()) continue;
            this.upgradeResourceList(spaceResources, ctx);
            this.bandanaManager.setValue((BandanaContext)ctx, "atlassian.confluence.user.resources", (Object)spaceResources);
        }
    }

    private void upgradeGlobalResources() {
        Space space = null;
        ConfluenceBandanaContext ctx = new ConfluenceBandanaContext(space);
        try {
            List globalResources = (List)this.bandanaManager.getValue((BandanaContext)ctx, "atlassian.confluence.user.resources", false);
            if (globalResources != null) {
                this.upgradeResourceList(globalResources, ctx);
                this.bandanaManager.setValue((BandanaContext)ctx, "atlassian.confluence.user.resources", (Object)globalResources);
            }
        }
        catch (Exception e) {
            this.errors.add("Error accessing global confluence bandana context - please contact confluence-support@atlassian.com: " + e);
        }
    }

    private void upgradeResourceList(List resourceList, ConfluenceBandanaContext ctx) {
        for (int i = 0; i < resourceList.size(); ++i) {
            try {
                Resource r = (Resource)resourceList.get(i);
                if (r.getFile() == null) continue;
                String filename = r.getFile().getAbsolutePath();
                int startIdx = -1;
                String confHome = this.bootstrapManager.getConfluenceHome();
                startIdx = filename.indexOf(confHome);
                String relativePath = null;
                if (startIdx != -1) {
                    relativePath = filename.substring(startIdx + confHome.length());
                }
                if (relativePath == null) continue;
                r.setRelativePathToFile(relativePath);
                r.setFile(null);
                continue;
            }
            catch (ClassCastException e) {
                log.fatal((Object)("Found something that was not of type com.atlassian.confluence.util.Resource in the b context with spaceKey [" + ctx.getSpaceKey() + "]"), (Throwable)e);
            }
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public BandanaManager getBandanaManager() {
        return this.bandanaManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public BootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }
}

