/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class SetGlobalSpaceTypeUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(SetGlobalSpaceTypeUpgradeTask.class);

    public String getBuildNumber() {
        return "508";
    }

    public String getShortDescription() {
        return "Sets the space type of all existing global spaces";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Beginning database update: global spaces");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        try {
            this.updateDatabase(SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true));
        }
        finally {
            log.info((Object)"Completed database update: global spaces");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDatabase(Session session) throws HibernateException, SQLException {
        Statement statement = null;
        try {
            Connection connection = session.connection();
            statement = connection.createStatement();
            statement.execute("update SPACES set SPACETYPE = '" + SpaceType.GLOBAL.toString() + "' where SPACETYPE is NULL");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.closeStatementQuietly(statement);
            throw throwable;
        }
        SQLUtils.closeStatementQuietly(statement);
    }

    public Collection getErrors() {
        return null;
    }
}

